/*
 * Cafebabe Commons xmlcli: build options object of jakarta commons-cli from xml definition.
 * Copyright (C) 2006 Haruaki TAMADA
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package jp.sourceforge.talisman.xmlcli.io;

/*
 * $Id: Argf.java,v 1.2 2006/02/26 09:47:59 harua-t Exp $
 */

/**
 * If command line arguments are exists, this interface represents a
 * stream to open files (arguments) in a sequence.  If arguments are
 * not exists, this interface reprensents a standard input stream.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 1.2 $ $Date: 2006/02/26 09:47:59 $
 * @see jp.sourceforge.talisman.xmlcli.io.ArgfInputStream
 * @see jp.sourceforge.talisman.xmlcli.io.ArgfReader
 */
public interface Argf {
    public String getFileName();

    public boolean isStdin();

    public void addStreamChangeListener(StreamChangeListener listener);

    public void removeStreamChangeListener(StreamChangeListener listener);
}
