/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.pcp;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import jp.sourceforge.talisman.pcp.Metrics;
import jp.sourceforge.talisman.pcp.Samples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sample
implements Serializable {
    private static final long serialVersionUID = 4929816297324672494L;
    private String id;
    private Map<Metrics, Integer> metricsMap = new LinkedHashMap<Metrics, Integer>();
    private boolean active = true;
    private Samples samples;

    public Sample(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = id;
    }

    public Sample(String id, Samples samples) {
        this(id);
        this.setSamples(samples);
    }

    public void setSamples(Samples samples) {
        if (samples == null) {
            throw new NullPointerException();
        }
        for (Metrics metrics : this.metricsMap.keySet()) {
            samples.addMetrics(metrics);
        }
        this.samples = samples;
    }

    public Samples getSamples() {
        return this.samples;
    }

    public String getId() {
        return this.id;
    }

    public Iterator<Metrics> metrics() {
        LinkedHashSet<Metrics> metricsSet = new LinkedHashSet<Metrics>(this.metricsMap.keySet());
        return metricsSet.iterator();
    }

    public boolean hasValue(Metrics metrics) {
        return this.metricsMap.get(metrics) != null;
    }

    public void removeValue(Metrics metrics) {
        this.metricsMap.remove(metrics);
    }

    public Integer getValue(Metrics metrics) {
        return this.metricsMap.get(metrics);
    }

    public void setValue(Metrics metrics, int value) {
        this.metricsMap.put(metrics, new Integer(value));
        if (this.samples != null) {
            this.samples.addMetrics(metrics);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean selected) {
        this.active = selected;
    }

    public boolean equals(Object o) {
        boolean flag = false;
        if (o instanceof Sample) {
            Sample s = (Sample)o;
            Iterator<Map.Entry<Metrics, Integer>> i1 = this.metricsMap.entrySet().iterator();
            Iterator<Map.Entry<Metrics, Integer>> i2 = s.metricsMap.entrySet().iterator();
            flag = true;
            while (flag && i1.hasNext() && i2.hasNext()) {
                Map.Entry<Metrics, Integer> m1 = i1.next();
                Map.Entry<Metrics, Integer> m2 = i2.next();
                flag = flag && m1.getKey().equals(m2.getKey()) && m1.getValue().equals(m2.getValue());
            }
            flag = flag && !i1.hasNext() && !i2.hasNext();
        }
        return flag;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.id);
        sb.append("={ ");
        boolean first = true;
        for (Map.Entry<Metrics, Integer> entry : this.metricsMap.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("[").append(entry.getKey().getName());
            sb.append("=").append(entry.getValue()).append("]");
            first = false;
        }
        sb.append(" }");
        return new String(sb);
    }
}

