/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.csvio;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jp.sourceforge.talisman.csvio.CsvIOSetting;
import jp.sourceforge.talisman.csvio.CsvLine;
import jp.sourceforge.talisman.csvio.CsvLineBuilder;
import jp.sourceforge.talisman.csvio.builder.CsvLineBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvParser
implements Iterator<CsvLine> {
    private BufferedReader in;
    private String nextLine;
    private boolean first = true;
    private CsvLineBuilder builder;

    public CsvParser(BufferedReader in) {
        this(in, new CsvIOSetting());
    }

    public CsvParser(BufferedReader in, CsvIOSetting setting) {
        this.in = in;
        this.builder = CsvLineBuilderFactory.getInstance().createBuilder(setting);
    }

    public CsvIOSetting getSetting() {
        return this.builder.getSetting();
    }

    public void setSetting(CsvIOSetting setting) {
        this.builder = CsvLineBuilderFactory.getInstance().createBuilder(setting);
    }

    public CsvLine[] getAllLines() {
        ArrayList<CsvLine> lines = new ArrayList<CsvLine>();
        while (this.hasNext()) {
            lines.add(this.next());
        }
        return lines.toArray(new CsvLine[lines.size()]);
    }

    @Override
    public CsvLine next() {
        if (this.first) {
            this.getNextLine();
            this.first = false;
        }
        CsvLine line = null;
        if (this.nextLine != null) {
            line = this.builder.buildCsvLine(this.nextLine);
        }
        this.getNextLine();
        return line;
    }

    @Override
    public boolean hasNext() {
        if (this.first) {
            this.getNextLine();
            this.first = false;
        }
        return this.nextLine != null;
    }

    @Override
    public void remove() {
    }

    private void getNextLine() {
        try {
            this.nextLine = this.in.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

