/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.pcp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jp.sourceforge.talisman.pcp.Criterion;
import jp.sourceforge.talisman.pcp.Metrics;
import jp.sourceforge.talisman.pcp.Sample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Samples
implements Serializable,
Iterable<Sample> {
    private static final long serialVersionUID = 947291361173171290L;
    private List<Sample> samples = new ArrayList<Sample>();
    private Set<Metrics> metricsSet = new LinkedHashSet<Metrics>();
    private int selectedCount;

    public void addSample(Sample sample) {
        this.samples.add(sample);
        this.calculateSelectedCount();
    }

    public void removeSample(Sample sample) {
        this.samples.remove(sample);
        this.calculateSelectedCount();
    }

    public synchronized Metrics[] getAvailableMetrics() {
        return this.metricsSet.toArray(new Metrics[this.metricsSet.size()]);
    }

    public int getSampleCount() {
        return this.samples.size();
    }

    public int getSelectedSampleCount() {
        return this.selectedCount;
    }

    public synchronized Sample[] getSamples() {
        return this.samples.toArray(new Sample[this.samples.size()]);
    }

    @Override
    public Iterator<Sample> iterator() {
        return this.samples.iterator();
    }

    public synchronized Sample[] getSelectedSamples() {
        ArrayList<Sample> selectedSample = new ArrayList<Sample>();
        for (Sample sample : this) {
            if (!sample.isActive()) continue;
            selectedSample.add(sample);
        }
        return selectedSample.toArray(new Sample[selectedSample.size()]);
    }

    public void setSelected(Metrics metrics, int value, Criterion criterion) {
        this.selectedCount = 0;
        for (Sample sample : this) {
            int v = sample.getValue(metrics);
            boolean flag = true;
            switch (criterion) {
                case EQUALS: {
                    flag = v == value;
                    break;
                }
                case LESS: {
                    flag = v < value;
                    break;
                }
                case LESS_EQUALS: {
                    flag = v <= value;
                    break;
                }
                case MORE: {
                    flag = v > value;
                    break;
                }
                case MORE_EQUALS: {
                    flag = v >= value;
                }
            }
            sample.setActive(flag);
            if (!flag) continue;
            ++this.selectedCount;
        }
    }

    void addMetrics(Metrics metrics) {
        this.metricsSet.add(metrics);
    }

    private void calculateSelectedCount() {
        this.selectedCount = 0;
        for (Sample sample : this) {
            if (!sample.isActive()) continue;
            ++this.selectedCount;
        }
    }
}

