/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.csvio;

import java.io.Serializable;
import jp.sourceforge.talisman.csvio.EscapeMode;
import jp.sourceforge.talisman.csvio.QuotationMode;

public class CsvIOSetting
implements Serializable {
    private static final long serialVersionUID = -3459860376638200048L;
    private char separator;
    private char quoteBegin;
    private char quoteEnd;
    private char escapeCharacter = (char)92;
    private QuotationMode quotationMode;
    private EscapeMode escapeMode;

    public CsvIOSetting() {
        this(',', '\"', '\"', QuotationMode.AS_NEEDED, EscapeMode.DOUBLE_CHARACTER);
    }

    public CsvIOSetting(char separator) {
        this(separator, '\"', '\"', QuotationMode.AS_NEEDED, EscapeMode.DOUBLE_CHARACTER);
    }

    public CsvIOSetting(char separator, char quoteBegin, char quoteEnd, QuotationMode quotationMode, EscapeMode escapeMode) {
        this(separator, quoteBegin, quoteEnd, quotationMode, escapeMode, '\\');
    }

    public CsvIOSetting(char separator, char quoteBegin, char quoteEnd, QuotationMode quotationMode, EscapeMode escapeMode, char escapeChar) {
        this.setSeparator(separator);
        this.setQuoteBegin(quoteBegin);
        this.setQuoteEnd(quoteEnd);
        this.setQuotationMode(quotationMode);
        this.setEscapeMode(escapeMode);
        this.setEscapeCharacter(escapeChar);
    }

    public CsvIOSetting(CsvIOSetting setting) {
        this.setSeparator(setting.getSeparator());
        this.setQuoteBegin(setting.getQuoteBegin());
        this.setQuoteEnd(setting.getQuoteEnd());
        this.setQuotationMode(setting.getQuotationMode());
        this.setEscapeMode(setting.getEscapeMode());
        this.setEscapeCharacter(setting.getEscapeCharacter());
    }

    public QuotationMode getQuotationMode() {
        return this.quotationMode;
    }

    public void setQuotationMode(QuotationMode mode) {
        this.quotationMode = mode;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setEscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public EscapeMode getEscapeMode() {
        return this.escapeMode;
    }

    public void setEscapeMode(EscapeMode escapeMode) {
        this.escapeMode = escapeMode;
    }

    public char getQuoteBegin() {
        return this.quoteBegin;
    }

    public void setQuoteBegin(char quoteBegin) {
        this.quoteBegin = quoteBegin;
    }

    public char getQuoteEnd() {
        return this.quoteEnd;
    }

    public void setQuoteEnd(char quoteEnd) {
        this.quoteEnd = quoteEnd;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public boolean equals(Object o) {
        if (o instanceof CsvIOSetting) {
            CsvIOSetting s = (CsvIOSetting)o;
            return s.getSeparator() == this.getSeparator() && s.getEscapeCharacter() == this.getEscapeCharacter() && s.getQuoteBegin() == this.getQuoteBegin() && s.getQuoteEnd() == this.getQuoteEnd() && s.getEscapeMode() == this.getEscapeMode() && s.getQuotationMode() == this.getQuotationMode();
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

