package jp.sourceforge.talisman.pcp.ui.swing.actions;

/*
 * $Id: InactiveLineColorSelectAction.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.awt.Color;
import java.awt.event.ActionEvent;

import jp.sourceforge.talisman.pcp.ui.swing.PcpPane;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class InactiveLineColorSelectAction extends ColorChooserShowAction{
    private static final long serialVersionUID = -646374330082527621L;

    private PcpPane pcp;

    public InactiveLineColorSelectAction(PcpPane pcp){
        this.pcp = pcp;
        putValue(ACTION_COMMAND_KEY, "inactivelinecolor.select");
        putValue(NAME, pcp.getMessages().get("inactivelinecolor.label"));
        if(pcp.getMessages().hasValue("inactivelinecolor.icon")){
            putValue(SMALL_ICON, pcp.getMessages().getIcon("inactivelinecolor.icon"));
        }
    }

    public void actionPerformed(ActionEvent e){
        Color newColor = chooseColor(pcp, pcp.getSetting().getInactiveLineColor(), pcp);

        pcp.getSetting().setInactiveLineColor(newColor);
    }
}
