package jp.sourceforge.talisman.pcp;

/*
 * $Id: MetricsTest.java 132 2008-07-15 03:30:47Z tama3 $
 */

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.assertNull;

import org.junit.Test;
/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class MetricsTest{
    @Test
    public void testBasic(){
        Metrics metrics = new Metrics("metrics1");
        assertEquals("metrics1", metrics.getName());

        assertNull(metrics.getDescription());
    }

    @Test(expected=NullPointerException.class)
    public void testNullName(){
        new Metrics((String)null);
    }

    @Test
    public void testDescription(){
        Metrics metrics = new Metrics("metrics1");

        metrics.setDescrpition("description");
        assertEquals("description", metrics.getDescription());
    }

    @Test
    public void testEquals(){
        Metrics metrics1 = new Metrics("metrics1");
        Metrics metrics2 = new Metrics("metrics2");
        Metrics metrics3 = new Metrics(metrics1);
        Metrics metrics4 = new Metrics("metrics2");

        assertFalse(metrics1.equals(metrics2));
        assertTrue(metrics1.equals(metrics3));
        assertTrue(metrics2.equals(metrics4));
    }
}
