package jp.sourceforge.talisman.pcp.ui.swing.actions;

/*
 * $Id: SelectedAreaColorSelectAction.java 132 2008-07-15 03:30:47Z tama3 $
 */

import java.awt.Color;
import java.awt.event.ActionEvent;

import jp.sourceforge.talisman.pcp.ui.swing.PcpPane;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class SelectedAreaColorSelectAction extends ColorChooserShowAction{
    private static final long serialVersionUID = 7072434781017468057L;

    private PcpPane pcp;

    public SelectedAreaColorSelectAction(PcpPane pcp){
        this.pcp = pcp;
        putValue(ACTION_COMMAND_KEY, "selectedareacolor.select");
        putValue(NAME, pcp.getMessages().get("selectedareacolor.label"));
        if(pcp.getMessages().hasValue("selectedareacolor.icon")){
            putValue(SMALL_ICON, pcp.getMessages().getIcon("selectedareacolor.icon"));
        }
    }

    public void actionPerformed(ActionEvent e){
        Color newColor = chooseColor(pcp, pcp.getSetting().getSelectedAreaColor(), pcp);

        pcp.getSetting().setSelectedAreaColor(newColor);
    }
}
