package jp.sourceforge.talisman.pcp.io;

/*
 * $Id: SamplesParserTest.java 132 2008-07-15 03:30:47Z tama3 $
 */

import static org.junit.Assert.assertEquals;

import java.io.ByteArrayInputStream;
import java.io.StringReader;

import jp.sourceforge.talisman.pcp.Metrics;
import jp.sourceforge.talisman.pcp.Sample;
import jp.sourceforge.talisman.pcp.Samples;

import org.junit.Before;
import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 132 $ 
 */
public class SamplesParserTest{
    private String sampleCsv = ",aaa, bbb, ccc, ddd, \"eee,fff\"\r\n" +
        "alpha, 20, 30, 40, 50, 60\r\n" +
        "beta,  21, 31, 41, 51, 61\r\n" +
        "gamma, 22, 32, 42, 52, 62\r\n" +
        "theta, 23, 33, 43, 53, 63\r\n";
    private SamplesParser parser;

    @Before
    public void setUp(){
        parser = new SamplesParser();
    }

    @Test
    public void testNormalByReader() throws Exception{
        Samples samples = parser.parse(new StringReader(sampleCsv));

        assertEquals(4, samples.getSampleCount());

        Sample[] sample = samples.getSamples();
        assertEquals("alpha", sample[0].getId());
        assertEquals("beta",  sample[1].getId());
        assertEquals("gamma", sample[2].getId());
        assertEquals("theta", sample[3].getId());

        Metrics[] metric = samples.getAvailableMetrics();
        assertEquals("aaa", metric[0].getName());
        assertEquals("bbb", metric[1].getName());
        assertEquals("ccc", metric[2].getName());
        assertEquals("ddd", metric[3].getName());
        assertEquals("eee,fff", metric[4].getName());
    }

    @Test
    public void testNormalByInputStream() throws Exception{
        Samples samples = parser.parse(new ByteArrayInputStream(sampleCsv.getBytes()));

        assertEquals(4, samples.getSampleCount());

        Sample[] sample = samples.getSamples();
        assertEquals("alpha", sample[0].getId());
        assertEquals("beta",  sample[1].getId());
        assertEquals("gamma", sample[2].getId());
        assertEquals("theta", sample[3].getId());

        Metrics[] metric = samples.getAvailableMetrics();
        assertEquals("aaa", metric[0].getName());
        assertEquals("bbb", metric[1].getName());
        assertEquals("ccc", metric[2].getName());
        assertEquals("ddd", metric[3].getName());
        assertEquals("eee,fff", metric[4].getName());
    }
}