/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.fmv;

public class MemoryState {
    private long free;
    private long total;
    private long max;

    public MemoryState(long free, long total, long max) {
        this.free = free;
        this.total = total;
        this.max = max;
    }

    public MemoryState() {
        Runtime runtime = Runtime.getRuntime();
        this.free = runtime.freeMemory();
        this.total = runtime.totalMemory();
        this.max = runtime.maxMemory();
    }

    public boolean isMaxLimitted() {
        return this.max != Long.MAX_VALUE;
    }

    public long getFreeMemory() {
        return this.free;
    }

    public long getTotalMemory() {
        return this.total;
    }

    public long getMaxMemory() {
        return this.max;
    }

    public long getUsedMemory() {
        return this.getTotalMemory() - this.getFreeMemory();
    }

    public double getUsedMemoryRatio() {
        return (double)this.getUsedMemory() / (double)this.getTotalMemory();
    }

    public String toString() {
        return String.format("free: %d/%d, max: %s (%s)", this.getFreeMemory(), this.getTotalMemory(), this.getMaxMemory(), this.isMaxLimitted());
    }
}

