/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.fmv.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import jp.sourceforge.talisman.fmv.MemoryState;
import jp.sourceforge.talisman.fmv.MemoryStateNotifyListener;
import jp.sourceforge.talisman.fmv.RunningListener;
import jp.sourceforge.talisman.fmv.TimeredMemoryStateNotifier;
import jp.sourceforge.talisman.fmv.ui.FmvGraphSetting;
import jp.sourceforge.talisman.fmv.ui.PopupShowAction;
import jp.sourceforge.talisman.fmv.ui.swing.FmvGraphSettingPane;
import jp.sourceforge.talisman.i18n.MessageManager;
import jp.sourceforge.talisman.i18n.Messages;
import jp.sourceforge.talisman.i18n.ResourceNotFoundException;

public class MemoryGraphPane
extends JPanel
implements MessageManager {
    private static final long serialVersionUID = 6262828285348015917L;
    private TimeredMemoryStateNotifier notifier;
    private FmvGraphSetting settings;
    private ViewerPanel viewerPanel;
    private Box buttonPanel;
    private JPanel detailPanel;
    private JLabel totalMemoryLabel;
    private JLabel freeMemoryLabel;
    private JLabel usageLabel;
    private Messages messages;
    private List<MemoryState> memoryList = new ArrayList<MemoryState>();
    private long max = 0L;

    public MemoryGraphPane() throws ResourceNotFoundException {
        this(new FmvGraphSetting());
    }

    public MemoryGraphPane(Messages messages) {
        this(new FmvGraphSetting(), messages);
    }

    public MemoryGraphPane(FmvGraphSetting settings) throws ResourceNotFoundException {
        this(settings, new Messages("resources.fmv"));
    }

    public MemoryGraphPane(FmvGraphSetting settings, Messages messages) {
        this.settings = settings;
        this.messages = messages;
        this.notifier = new TimeredMemoryStateNotifier();
        this.notifier.addNotifyListener(new MemoryStateNotifyListener(){

            public void currentMemoryStateNotified(MemoryState state) {
                MemoryGraphPane.this.updateView(state);
            }
        });
        this.initLayouts();
        this.setGraphSettings(settings);
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                MemoryGraphPane.this.notifier.start();
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
                MemoryGraphPane.this.notifier.stop();
            }
        });
    }

    public Messages getMessages() {
        return this.messages;
    }

    public void addMemoryStateNotifyListener(MemoryStateNotifyListener listener) {
        this.notifier.addNotifyListener(listener);
    }

    public void removeMemoryStateNotifyListener(MemoryStateNotifyListener listener) {
        this.notifier.removeNotifyListener(listener);
    }

    public FmvGraphSetting getGraphSettings() {
        return this.settings;
    }

    public void setGraphSettings(FmvGraphSetting settings) {
        this.settings = settings;
        if (settings.isShowConfigurationButton()) {
            this.add((Component)this.buttonPanel, "South");
        } else {
            this.remove(this.buttonPanel);
        }
        if (settings.isShowDetails()) {
            this.add((Component)this.detailPanel, "North");
        } else {
            this.remove(this.detailPanel);
        }
        this.notifier.setInterval(settings.getInterval());
        this.viewerPanel.setMinimumSize(settings.getMinimumSize());
        this.viewerPanel.setPreferredSize(settings.getMinimumSize());
        Window window = SwingUtilities.windowForComponent(this);
        if (window != null) {
            window.pack();
        }
    }

    private void initLayouts() {
        this.viewerPanel = new ViewerPanel();
        this.buttonPanel = Box.createHorizontalBox();
        this.detailPanel = new JPanel(new GridLayout(1, 3));
        this.freeMemoryLabel = new JLabel();
        this.detailPanel.add(this.freeMemoryLabel);
        this.totalMemoryLabel = new JLabel();
        this.detailPanel.add(this.totalMemoryLabel);
        this.usageLabel = new JLabel();
        this.detailPanel.add(this.usageLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.viewerPanel, "Center");
        if (this.settings.isShowConfigurationButton()) {
            this.add((Component)this.buttonPanel, "South");
        }
        if (this.settings.isShowDetails()) {
            this.add((Component)this.detailPanel, "North");
        }
        this.freeMemoryLabel.setBorder(new TitledBorder(this.messages.get("freememory.label")));
        this.totalMemoryLabel.setBorder(new TitledBorder(this.messages.get("totalmemory.label")));
        this.usageLabel.setBorder(new TitledBorder(this.messages.get("useratio.label")));
        ConfigAction configAction = new ConfigAction(this, this);
        GcAction gcAction = new GcAction(this, this);
        StartStopAction startStopAction = new StartStopAction(this.notifier, this);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(new JButton(configAction));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(new JButton(gcAction));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(new JButton(startStopAction));
        this.buttonPanel.add(Box.createHorizontalGlue());
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem(configAction));
        popup.add(new JMenuItem(gcAction));
        popup.add(new JMenuItem(startStopAction));
        this.viewerPanel.addMouseListener(new PopupShowAction(popup));
    }

    private void updateView(MemoryState state) {
        this.memoryList.add(state);
        System.out.println(state);
        while (this.memoryList.size() > this.settings.getHistoryCount()) {
            this.memoryList.remove(0);
        }
        if (this.max < state.getTotalMemory()) {
            this.max = state.getTotalMemory();
        }
        this.freeMemoryLabel.setText(Long.toString(state.getFreeMemory()));
        this.totalMemoryLabel.setText(Long.toString(state.getTotalMemory()));
        this.usageLabel.setText(String.format("%g %%", state.getUsedMemoryRatio() * 100.0));
        this.viewerPanel.repaint();
    }

    public static void main(String[] args) throws ResourceNotFoundException {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        f.add(new MemoryGraphPane());
        f.pack();
        f.setVisible(true);
    }

    private static class GcAction
    extends FmvAction {
        private static final long serialVersionUID = 6363441797189312138L;
        private MemoryGraphPane memoryGraphPane;

        public GcAction(MemoryGraphPane memoryGraphPane, MessageManager mm) {
            super(mm, "gc");
            this.memoryGraphPane = memoryGraphPane;
        }

        public void actionPerformed(ActionEvent e) {
            int type = JOptionPane.showConfirmDialog(this.memoryGraphPane, this.memoryGraphPane.getMessages().get("message.exec-gc"), this.memoryGraphPane.getMessages().get("title.exec-gc"), 2, 3);
            if (type == 0) {
                System.gc();
            }
        }
    }

    private static class ConfigAction
    extends FmvAction {
        private static final long serialVersionUID = -844806456041681421L;
        private MemoryGraphPane memoryGraphPane;

        public ConfigAction(MemoryGraphPane memoryGraphPane, MessageManager mm) {
            super(mm, "config");
            this.memoryGraphPane = memoryGraphPane;
        }

        public FmvGraphSetting getSetting(FmvGraphSetting fgs) {
            FmvGraphSettingPane panel = new FmvGraphSettingPane(this, fgs);
            int confirmType = JOptionPane.showConfirmDialog(this.memoryGraphPane, panel, this.getMessages().get("config.title"), 2, 1);
            FmvGraphSetting newFgs = null;
            if (confirmType == 0) {
                newFgs = panel.getGraphSetting();
            }
            return newFgs;
        }

        public void actionPerformed(ActionEvent e) {
            boolean running = this.memoryGraphPane.notifier.isRunning();
            this.memoryGraphPane.notifier.stop();
            FmvGraphSetting fgs = this.getSetting(this.memoryGraphPane.getGraphSettings());
            if (fgs != null) {
                this.memoryGraphPane.setGraphSettings(fgs);
            }
            if (running) {
                this.memoryGraphPane.notifier.start();
            }
        }
    }

    private static class StartStopAction
    extends FmvAction {
        private static final long serialVersionUID = -3567505632132908195L;
        private TimeredMemoryStateNotifier notifier;

        public StartStopAction(TimeredMemoryStateNotifier notifier, MessageManager mm) {
            super(mm, "startstop");
            this.notifier = notifier;
            notifier.addRunningListener(new RunningListener(){

                public void timerStarted() {
                    StartStopAction.this.putValue("Name", StartStopAction.this.getMessages().get("stop.label"));
                    StartStopAction.this.putValue("SmallIcon", StartStopAction.this.getMessages().getIcon("stop.icon"));
                }

                public void timerStopped() {
                    StartStopAction.this.putValue("Name", StartStopAction.this.getMessages().get("start.label"));
                    StartStopAction.this.putValue("SmallIcon", StartStopAction.this.getMessages().getIcon("start.icon"));
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            if (this.notifier.isRunning()) {
                this.notifier.stop();
            } else {
                this.notifier.start();
            }
        }
    }

    private static abstract class FmvAction
    extends AbstractAction
    implements MessageManager {
        private MessageManager mm;

        public FmvAction(MessageManager mm, String label) {
            super(mm.getMessages().get(label + ".label"), mm.getMessages().getIcon(label + ".icon"));
            this.mm = mm;
        }

        public Messages getMessages() {
            return this.mm.getMessages();
        }
    }

    private class ViewerPanel
    extends JComponent {
        private static final long serialVersionUID = 4434644949345620306L;

        private ViewerPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            Dimension dim = this.getSize();
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight());
            g.setColor(MemoryGraphPane.this.settings.getBackgroundColor());
            g.fill(rect);
            if (MemoryGraphPane.this.settings.isShowSubGrid()) {
                g.setColor(MemoryGraphPane.this.settings.getSubGridColor());
                this.drawGrid(g, dim, 16);
            }
            if (MemoryGraphPane.this.settings.isShowGrid()) {
                g.setColor(MemoryGraphPane.this.settings.getGridColor());
                this.drawGrid(g, dim, 8);
            }
            g.setColor(MemoryGraphPane.this.settings.getStringColor());
            if (MemoryGraphPane.this.settings.isShowGraphLabel()) {
                this.drawGraphLabel(g, dim);
            }
            g.setColor(MemoryGraphPane.this.settings.getForegroundColor());
            if (MemoryGraphPane.this.memoryList.size() > 0) {
                List list = MemoryGraphPane.this.memoryList;
                synchronized (list) {
                    float dw = (float)(dim.getWidth() / (double)MemoryGraphPane.this.settings.getStepCount());
                    GeneralPath path = new GeneralPath();
                    int index = MemoryGraphPane.this.memoryList.size() - MemoryGraphPane.this.settings.getStepCount();
                    if (index < 0) {
                        index = 0;
                    }
                    MemoryState ms = (MemoryState)MemoryGraphPane.this.memoryList.get(index);
                    if (MemoryGraphPane.this.settings.isFill()) {
                        path.moveTo(0.0f, (float)dim.getHeight());
                        path.lineTo(0.0f, (float)(dim.getHeight() / (double)MemoryGraphPane.this.max * (double)ms.getFreeMemory()));
                    } else {
                        path.moveTo(0.0f, (float)(dim.getHeight() / (double)MemoryGraphPane.this.max * (double)ms.getFreeMemory()));
                    }
                    for (int i = 1; i < MemoryGraphPane.this.settings.getStepCount() && index + i < MemoryGraphPane.this.memoryList.size(); ++i) {
                        ms = (MemoryState)MemoryGraphPane.this.memoryList.get(index + i);
                        path.lineTo(0.0f + (float)i * dw, (float)(dim.getHeight() / (double)MemoryGraphPane.this.max * (double)ms.getFreeMemory()));
                    }
                    if (MemoryGraphPane.this.settings.isFill()) {
                        path.lineTo(0.0f + dw * (float)(MemoryGraphPane.this.memoryList.size() - 1), (float)dim.getHeight());
                        g.fill(path);
                    } else {
                        g.draw(path);
                    }
                }
            }
        }

        private void drawGraphLabel(Graphics2D g, Dimension d) {
            double dw = (d.getWidth() - 1.0) / 8.0;
            double dh = (d.getHeight() - 1.0) / 8.0;
            Font font = this.getFont();
            FontMetrics metircs = g.getFontMetrics(font);
            g.drawString("  0%", (float)(dw * 4.0), (float)(dh * 8.0));
            g.drawString(" 25%", (float)(dw * 4.0), (float)(dh * 6.0));
            g.drawString(" 50%", (float)(dw * 4.0), (float)(dh * 4.0));
            g.drawString(" 75%", (float)(dw * 4.0), (float)(dh * 2.0));
            g.drawString("100%", (float)(dw * 4.0), (float)(dh * 0.0) + (float)metircs.getHeight());
        }

        private void drawGrid(Graphics2D g, Dimension d, int val) {
            double dw = (d.getWidth() - 1.0) / (double)val;
            double dh = (d.getHeight() - 1.0) / (double)val;
            for (int i = 0; i <= val; ++i) {
                g.draw(new Line2D.Double(0.0, dh * (double)i, d.getWidth(), dh * (double)i));
                g.draw(new Line2D.Double(dw * (double)i, 0.0, dw * (double)i, d.getHeight()));
            }
        }
    }
}

