package jp.sourceforge.talisman.fmv;

/*
 * $Id: MemoryStateNotifier.java 148 2008-07-15 07:34:55Z tama3 $
 */

import java.util.ArrayList;
import java.util.List;

/**
 * Free memory observable class.
 * This class observes free memory at given interval.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 148 $
 */
public class MemoryStateNotifier{
    private List<MemoryStateNotifyListener> listeners;
    private MemoryState state = null;

    public MemoryStateNotifier(){
        listeners = new ArrayList<MemoryStateNotifyListener>();
    }

    public void addNotifyListener(MemoryStateNotifyListener listener){
        listeners.add(listener);
    }

    public void removeNotifyListener(MemoryStateNotifyListener listener){
        listeners.remove(listener);
    }

    public synchronized void informAll(){
        if(state != null){
            throw new IllegalStateException("illegal state, current memory status is already build");
        }
        state = new MemoryState();
        for(MemoryStateNotifyListener listener: listeners){
            inform(listener);
        }
        state = null;
    }

    public void inform(MemoryStateNotifyListener listener){
        MemoryState ms = state;
        if(ms == null){
            ms = new MemoryState();
        }
        listener.currentMemoryStateNotified(ms);
    }

    public long getTotalMemory(){
        return Runtime.getRuntime().totalMemory();
    }

    public long getMaxMemory(){
        return Runtime.getRuntime().maxMemory();
    }

    public long getUsedMemory(){
        return getTotalMemory() - getFreeMemory();
    }

    public long getFreeMemory(){
        return Runtime.getRuntime().freeMemory();
    }
}
