/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.talisman.hermes.maven.Artifact;

public class HermesEvent {
    private Id id;
    private List<Artifact> artifacts;
    private Artifact artifact;
    private int size;

    public HermesEvent(Id id) {
        this.id = id;
    }

    public HermesEvent(Id id, Artifact[] initialArtifacts) {
        this(id);
        this.artifacts = new ArrayList<Artifact>();
        for (Artifact artifact : initialArtifacts) {
            this.artifacts.add(artifact);
        }
    }

    public HermesEvent(Id id, Artifact artifact) {
        this(id);
        this.artifact = artifact;
    }

    public HermesEvent(Id id, Artifact artifact, int size) {
        this(id, artifact);
        this.size = size;
    }

    public Id getId() {
        return this.id;
    }

    public synchronized Artifact[] getArtifacts() {
        if (this.id != Id.TARGET_RESOLVED) {
            throw new IllegalStateException("This method is available on TARGET_RESOLVED");
        }
        return this.artifacts.toArray(new Artifact[this.artifacts.size()]);
    }

    public Artifact getArtifact() {
        if (this.id != Id.FILE_SIZE_UPDATED || this.id != Id.FILE_SIZE_GOTTEN || this.id != Id.DOWNLOAD_DONE) {
            throw new IllegalStateException("this method is available on FILE_SIZE_GOTTEN or FILE_SIZE_UPDATED");
        }
        return this.artifact;
    }

    public int getSize() {
        if (this.id != Id.FILE_SIZE_UPDATED || this.id != Id.FILE_SIZE_GOTTEN) {
            throw new IllegalStateException("this method is available on FILE_SIZE_GOTTEN or FILE_SIZE_UPDATED");
        }
        return this.size;
    }

    public static enum Id {
        TARGET_RESOLVED,
        FILE_SIZE_GOTTEN,
        FILE_SIZE_UPDATED,
        DOWNLOAD_DONE,
        FINISH;

    }
}

