/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.ui.swing;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

class CurrentDirectoryHandler
implements Serializable {
    private static final long serialVersionUID = -3424003758492729119L;
    private File currentDirectory;
    private List<FileFilter> filters = new ArrayList<FileFilter>();

    public CurrentDirectoryHandler() {
        this(new File("."));
    }

    public CurrentDirectoryHandler(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not directory");
        }
        this.currentDirectory = file;
    }

    public void addFileFilter(FileFilter filter) {
        this.filters.add(filter);
    }

    public synchronized FileFilter[] getFileFilters() {
        return this.filters.toArray(new FileFilter[this.filters.size()]);
    }

    public synchronized void registerFileFilter(JFileChooser chooser) {
        for (FileFilter filter : this.filters) {
            chooser.addChoosableFileFilter(filter);
        }
    }
}

