/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.ui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.ListSelectionModel;
import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.ui.swing.HermesContextBuilder;
import jp.sourceforge.talisman.hermes.ui.swing.SelectedAction;

class RemoveDependencyAction
extends SelectedAction {
    private static final long serialVersionUID = 2824865599779565655L;
    private HermesContextBuilder parent;
    private boolean versionFlag;

    public RemoveDependencyAction(HermesContextBuilder parent, ListSelectionModel model, boolean versionFlag) {
        this(parent, model);
        this.versionFlag = versionFlag;
    }

    public RemoveDependencyAction(HermesContextBuilder parent, ListSelectionModel model) {
        this("Remove", parent, model);
    }

    public RemoveDependencyAction(String name, HermesContextBuilder parent, ListSelectionModel model) {
        this(name, parent, model, true);
    }

    public RemoveDependencyAction(String name, HermesContextBuilder parent, ListSelectionModel model, boolean versionFlag) {
        super(name, model);
        this.parent = parent;
        this.versionFlag = versionFlag;
    }

    Component getParent() {
        return this.parent;
    }

    HermesContext getContext() {
        return this.parent.getContext();
    }

    boolean isIncludeVersion() {
        return this.versionFlag;
    }

    Artifact getDependency() {
        int index = this.getSelectionModel().getMinSelectionIndex();
        Artifact[] artifacts = this.getContext().getDependencies();
        if (index >= 0 && artifacts.length > index) {
            return artifacts[index];
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Artifact artifact = this.getDependency();
        if (artifact != null) {
            this.getContext().removeDependency(artifact);
        }
    }
}

