/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.talisman.hermes.DelegateHermesPercentageListener;
import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.HermesEvent;
import jp.sourceforge.talisman.hermes.HermesException;
import jp.sourceforge.talisman.hermes.HermesListener;
import jp.sourceforge.talisman.hermes.HermesPercentageListener;
import jp.sourceforge.talisman.hermes.VersionMismatchException;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;
import jp.sourceforge.talisman.hermes.maven.RepositoryItemNotFoundException;
import jp.sourceforge.talisman.hermes.maven.RepositoryManager;

public class Hermes {
    private HermesContext context;
    private List<HermesListener> listeners = new ArrayList<HermesListener>();
    private RepositoryManager manager;

    public Hermes(HermesContext context) {
        this.context = context;
        this.manager = new RepositoryManager(context);
    }

    public void addHermesListener(HermesListener listener) {
        this.listeners.add(listener);
    }

    public void addHermesListener(HermesPercentageListener listener) {
        this.addHermesListener(new DelegateHermesPercentageListener(listener));
    }

    public void install(Artifact artifact, InputStream in) throws IOException {
        this.uninstall(new Artifact(artifact.getGroupId(), artifact.getArtifactId()));
        String dest = this.getContext().getDestination();
        if (dest == null) {
            throw new IllegalStateException("destination is not specified");
        }
        File file = new File(dest, artifact.getFileName());
        FileOutputStream out = new FileOutputStream(file);
        byte[] data = new byte[1024];
        int len = 0;
        int size = 0;
        while ((len = in.read(data)) != -1) {
            ((OutputStream)out).write(data, 0, len);
            this.fireEvent(new HermesEvent(HermesEvent.Id.FILE_SIZE_UPDATED, artifact, size += len));
        }
        ((OutputStream)out).close();
        this.getContext().addDependency(artifact);
    }

    public void uninstall(Artifact artifact) {
        this.getContext().removeDependency(artifact);
        if (this.getContext().getDestination() != null) {
            File file = new File(this.getContext().getDestination());
            for (File f : file.listFiles()) {
                if (!f.getName().matches(artifact.getArtifactId() + "-[0-9.-]+.+.jar")) continue;
                f.renameTo(new File(f.getParentFile(), f.getName() + ".uninstalled"));
                break;
            }
        }
    }

    public boolean canUpdate() throws IOException, HermesException {
        return this.canUpdate(this.getContext().getDependencies());
    }

    public boolean canUpdate(Artifact artifact) throws IOException, HermesException {
        return this.canUpdate(new Artifact[]{artifact});
    }

    public boolean canUpdate(Artifact[] originalArtifacts) throws IOException, HermesException {
        return this.getUpdateTarget(originalArtifacts).length > 0;
    }

    public Artifact findArtifact(Artifact artifact) throws IOException {
        return this.manager.findArtifact(artifact);
    }

    public Artifact findArtifact(String groupId, String artifactId) throws IOException {
        return this.manager.findArtifact(groupId, artifactId, null);
    }

    public Artifact findArtifact(String groupId, String artifactId, String version) throws IOException {
        return this.manager.findArtifact(groupId, artifactId, version);
    }

    public HermesContext getContext() {
        return this.context;
    }

    public Artifact[] getDependencies() throws IOException, HermesException {
        return this.getDependencies(this.getContext().getDependencies());
    }

    public Artifact[] getDependencies(Artifact artifact) throws IOException, HermesException {
        return this.getDependencies(new Artifact[]{artifact});
    }

    public Artifact[] getDependencies(Artifact[] artifacts) throws IOException, HermesException {
        LinkedHashMap<String, Map<String, Artifact>> map = new LinkedHashMap<String, Map<String, Artifact>>();
        this.findDependencies(artifacts, map);
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        for (Map m : map.values()) {
            for (Artifact a : m.values()) {
                list.add(a);
            }
        }
        return list.toArray(new Artifact[list.size()]);
    }

    public void removeHermesListener(HermesListener listener) {
        this.listeners.remove(listener);
    }

    public void removeHermesListener(HermesPercentageListener removeTargetListener) {
        HermesListener removeTarget = null;
        for (HermesListener listener : this.listeners) {
            if (!(listener instanceof DelegateHermesPercentageListener) || removeTargetListener != ((DelegateHermesPercentageListener)listener).getListener()) continue;
            removeTarget = listener;
            break;
        }
        if (removeTarget != null) {
            this.listeners.remove(removeTarget);
        }
    }

    public void update() throws IOException, HermesException {
        this.update(this.getContext().getDependencies());
    }

    public void update(Artifact artifact) throws IOException, HermesException {
        this.update(new Artifact[]{artifact});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Artifact[] artifacts) throws IOException, HermesException {
        Artifact[] resolvedArtifacts = this.getUpdateTarget(artifacts);
        this.fireEvent(new HermesEvent(HermesEvent.Id.TARGET_RESOLVED, resolvedArtifacts));
        for (Artifact artifact : resolvedArtifacts) {
            URL url = artifact.getPom().getUrl();
            URLConnection connection = url.openConnection();
            int length = connection.getContentLength();
            this.fireEvent(new HermesEvent(HermesEvent.Id.FILE_SIZE_GOTTEN, artifact, length));
            InputStream in = null;
            try {
                in = connection.getInputStream();
                this.install(artifact, in);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            this.fireEvent(new HermesEvent(HermesEvent.Id.DOWNLOAD_DONE, artifact));
        }
        this.fireEvent(new HermesEvent(HermesEvent.Id.FINISH));
        for (Artifact a : resolvedArtifacts) {
            this.getContext().removeDependency(a.getGroupId(), a.getArtifactId());
            this.getContext().addDependency(a);
        }
    }

    public Artifact[] getUpdateTarget() throws IOException, HermesException {
        return this.getUpdateTarget(this.getContext().getDependencies());
    }

    public Artifact[] getUpdateTarget(Artifact originalArtifact) throws IOException, HermesException {
        return this.getUpdateTarget(new Artifact[]{originalArtifact});
    }

    public Artifact[] getUpdateTarget(Artifact[] artifacts) throws IOException, HermesException {
        List<Object> artifactList;
        Artifact[] targets = new Artifact[artifacts.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = this.findArtifact(artifacts[i].getGroupId(), artifacts[i].getArtifactId());
        }
        Artifact[] depResolvedArtifacts = this.getDependencies(targets);
        switch (this.getContext().getPolicy()) {
            case DESTINATION_CHECK: {
                artifactList = this.checkDestination(depResolvedArtifacts, artifacts);
                break;
            }
            case REPOSITORY_CHECK: {
                artifactList = this.checkRepository(depResolvedArtifacts, artifacts);
                break;
            }
            default: {
                artifactList = new ArrayList();
                for (Artifact artifact : depResolvedArtifacts) {
                    artifactList.add(artifact);
                }
            }
        }
        return artifactList.toArray(new Artifact[artifactList.size()]);
    }

    private List<Artifact> checkDestination(Artifact[] resolvedArtifacts, Artifact[] original) throws IOException {
        File file = new File(this.getContext().getDestination());
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath() + " is not found");
        }
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        File[] files = file.listFiles();
        Artifact[] arr$ = resolvedArtifacts;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Artifact artifact;
            Artifact target = artifact = arr$[i$];
            for (int i = 0; i < files.length; ++i) {
                String name;
                if (files[i] == null || !(name = files[i].getName()).startsWith(artifact.getArtifactId() + "-") || !name.endsWith(".jar")) continue;
                if (name.equals(artifact.getFileName())) {
                    target = null;
                }
                files[i] = null;
            }
            if (target == null) continue;
            artifactList.add(target);
        }
        return artifactList;
    }

    private List<Artifact> checkRepository(Artifact[] depResolvedArtifacts, Artifact[] artifacts) throws IOException, HermesException {
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        Artifact[] origDepArtifacts = this.getDependencies(artifacts);
        for (int j = 0; j < depResolvedArtifacts.length; ++j) {
            Artifact a1 = depResolvedArtifacts[j];
            int index = -1;
            for (int i = 0; i < origDepArtifacts.length; ++i) {
                Artifact a2 = origDepArtifacts[i];
                if (a2 == null || !a1.getGroupId().equals(a2.getGroupId()) || !a1.getArtifactId().equals(a2.getArtifactId())) continue;
                String version1 = a1.getVersion();
                String version2 = a2.getVersion();
                index = i;
                if (version1.equals(version2)) break;
                artifactList.add(a1);
                break;
            }
            if (index < 0) continue;
            origDepArtifacts[index] = null;
        }
        return artifactList;
    }

    private void findDependencies(Artifact[] artifacts, Map<String, Map<String, Artifact>> map) throws IOException, HermesException {
        for (Artifact artifact : artifacts) {
            if (!this.isTargetableScope(artifact) || !this.isTarget(artifact) || this.isAlreadyFound(artifact, map)) continue;
            this.checkVersion(artifact, map);
            Artifact resolvedArtifact = this.findArtifact(artifact);
            if (resolvedArtifact == null) {
                throw new RepositoryItemNotFoundException(String.format("%s:%s:%s not found", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
            }
            String groupId = resolvedArtifact.getGroupId();
            Map<String, Artifact> submap = map.get(groupId);
            if (submap == null) {
                submap = new LinkedHashMap<String, Artifact>();
                map.put(groupId, submap);
            }
            submap.put(resolvedArtifact.getArtifactId(), resolvedArtifact);
            Artifact[] newDependencies = resolvedArtifact.getDependencies();
            this.findDependencies(newDependencies, map);
        }
    }

    private void checkVersion(Artifact artifact, Map<String, Map<String, Artifact>> map) throws HermesException {
        if (map.get(artifact.getGroupId()) != null && map.get(artifact.getGroupId()).get(artifact.getArtifactId()) != null) {
            Artifact artifact2 = map.get(artifact.getGroupId()).get(artifact.getArtifactId());
            if (!artifact.getVersion().equals(artifact2.getVersion())) {
                throw new VersionMismatchException(String.format("%s:%s, version %s and %s", artifact2.getGroupId(), artifact2.getArtifactId(), artifact.getVersion(), artifact2.getVersion()));
            }
        }
    }

    private boolean isAlreadyFound(Artifact artifact, Map<String, Map<String, Artifact>> map) {
        Map<String, Artifact> submap = map.get(artifact.getGroupId());
        return submap != null && submap.get(artifact.getArtifactId()) != null;
    }

    private boolean isTarget(Artifact artifact) {
        return !this.getContext().isIgnore(artifact.getGroupId(), artifact.getArtifactId());
    }

    private boolean isTargetableScope(Artifact artifact) {
        DependencyScope scope = artifact.getScope();
        return scope == null || this.getContext().isInclude(scope);
    }

    private void fireEvent(HermesEvent e) {
        for (HermesListener listener : this.listeners) {
            switch (e.getId()) {
                case DOWNLOAD_DONE: {
                    listener.downloadDone(e);
                    break;
                }
                case FILE_SIZE_GOTTEN: {
                    listener.fileSizeGotten(e);
                    break;
                }
                case FILE_SIZE_UPDATED: {
                    listener.fileSizeUpdated(e);
                    break;
                }
                case FINISH: {
                    listener.finish(e);
                    break;
                }
                case TARGET_RESOLVED: {
                    listener.targetResolved(e);
                }
            }
        }
    }
}

