/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;
import jp.sourceforge.talisman.hermes.maven.Repository;

public class HermesContextExporter {
    public void export(File file, HermesContext context) throws IOException {
        FileWriter out = new FileWriter(file);
        this.export(out, context);
        ((Writer)out).close();
    }

    public void export(OutputStream out, HermesContext context) throws IOException {
        this.export(new OutputStreamWriter(out), context);
    }

    public void export(Writer out, HermesContext context) throws IOException {
        this.export(new PrintWriter(out), context);
    }

    public void export(PrintWriter out, HermesContext context) throws IOException {
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<hermes>");
        out.printf("  <repository-scope>%s</repository-scope>%n", context.getRepositoryScope().name());
        String dependencyScopeString = this.getDependencyScopeString(context);
        if (dependencyScopeString.length() > 0) {
            out.printf("  <dependency-scope>%s</dependency-scope>%n", dependencyScopeString);
        }
        if (context.getDestination() != null) {
            out.printf("  <destination>%s</destination>%n", context.getDestination());
        }
        if (context.getPolicy() != null) {
            out.printf("  <updating-policy>%s</updating-policy>%n", new Object[]{context.getPolicy()});
        }
        this.exportRepositories(out, context.getRepositories());
        this.exportDependencies(out, context.getDependencies());
        this.exportIgnores(out, context.getIgnores());
        out.println("</hermes>");
        out.flush();
    }

    private void exportIgnores(PrintWriter out, Artifact[] ignores) throws IOException {
        if (ignores.length > 0) {
            out.println("  <ignores>");
            for (Artifact artifact : ignores) {
                out.printf("    <ignore>%n", new Object[0]);
                out.printf("      <groupId>%s</groupId>%n", artifact.getGroupId());
                out.printf("      <artifactId>%s</artifactId>%n", artifact.getArtifactId());
                out.printf("    </ignore>%n", new Object[0]);
            }
            out.println("  </ignores>");
        }
    }

    private void exportDependencies(PrintWriter out, Artifact[] dependencies) throws IOException {
        if (dependencies.length > 0) {
            out.println("  <dependencies>");
            for (Artifact artifact : dependencies) {
                out.println("    <dependency>");
                out.printf("      <groupId>%s</groupId>%n", artifact.getGroupId());
                out.printf("      <artifactId>%s</artifactId>%n", artifact.getArtifactId());
                out.printf("      <version>%s</version>%n", artifact.getVersion());
                out.printf("      <scope>%s</scope>%n", new Object[]{artifact.getScope()});
                out.println("    </dependency>");
            }
            out.println("  </dependencies>");
        }
    }

    private void exportRepositories(PrintWriter out, Repository[] repositories) throws IOException {
        boolean neverWrite = true;
        for (Repository repository : repositories) {
            if (repository == Repository.getLocalRepository()) continue;
            if (neverWrite) {
                out.println("  <repositories>");
                neverWrite = false;
            }
            out.println("    <repository>");
            if (repository.getId() != null) {
                out.printf("      <id>%s</id>%n", repository.getId());
            }
            if (repository.getName() != null) {
                out.printf("      <name>%s</name>%n", repository.getName());
            }
            out.printf("      <url>%s</url>%n", repository.getLocation());
            out.println("    </repository>");
        }
        if (!neverWrite) {
            out.println("  </repositories>");
        }
    }

    private String getDependencyScopeString(HermesContext context) {
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        for (DependencyScope scope : DependencyScope.values()) {
            if (!context.isInclude(scope)) continue;
            if (flag) {
                sb.append(", ");
            }
            sb.append(scope.name());
            flag = true;
        }
        return new String(sb);
    }
}

