/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.maven;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.talisman.hermes.ResourceType;
import jp.sourceforge.talisman.hermes.maven.AbstractRepositoryItem;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.License;
import jp.sourceforge.talisman.hermes.maven.MavenPathUtils;
import jp.sourceforge.talisman.hermes.maven.Repository;

public class ProjectObjectModel
extends AbstractRepositoryItem
implements Iterable<Artifact> {
    private static final long serialVersionUID = -6483216367473616237L;
    private Artifact artifact;
    private List<Artifact> dependencies = new ArrayList<Artifact>();
    private List<License> licenses = new ArrayList<License>();
    private boolean read = false;
    private Repository repository;
    private ProjectObjectModel parent;

    ProjectObjectModel(Artifact artifact) {
        super(artifact.getGroupId(), artifact.getArtifactId());
        this.artifact = artifact;
    }

    public void addDependency(Artifact artifact) {
        this.dependencies.add(artifact);
    }

    public void addLicense(License license) {
        this.licenses.add(license);
    }

    public boolean equals(Object o) {
        if (o instanceof ProjectObjectModel) {
            boolean flag;
            ProjectObjectModel pom = (ProjectObjectModel)o;
            boolean bl = flag = this.read == pom.isAlreadyRead() && this.getGroupId().equals(pom.getGroupId()) && this.getArtifactId().equals(pom.getArtifactId());
            if (this.getVersion() != null) {
                flag = flag && this.getVersion().equals(pom.getVersion());
            } else {
                boolean bl2 = flag = flag && pom.getVersion() == null;
            }
            if (this.repository != null) {
                flag = flag && this.repository.equals(pom.repository);
            } else {
                boolean bl3 = flag = flag && pom.repository == null;
            }
            flag = this.getParent() != null ? flag && this.getParent().equals(pom.getParent()) : flag && pom.getParent() == null;
            return flag && Arrays.equals(this.getDependencies(), pom.getDependencies()) && Arrays.equals(this.getLicenses(), pom.getLicenses());
        }
        return false;
    }

    public synchronized Artifact[] getDependencies() {
        Artifact[] artifacts = this.dependencies.toArray(new Artifact[this.dependencies.size()]);
        if (artifacts.length == 0 && this.getParent() != null) {
            artifacts = this.getParent().getDependencies();
        }
        return artifacts;
    }

    public int getDependencyCount() {
        int count = this.dependencies.size();
        if (count == 0 && this.getParent() != null) {
            count = this.getParent().getDependencyCount();
        }
        return count;
    }

    @Override
    public String getFileName() {
        return this.getArtifactId() + "-" + this.artifact.getVersion() + "." + this.getType().getExtension();
    }

    public License getLicense() {
        return this.getLicense(0);
    }

    public License getLicense(int index) {
        return this.getLicenses()[index];
    }

    public int getLicenseCount() {
        int count = this.licenses.size();
        if (count == 0 && this.getParent() != null) {
            count = this.getParent().getLicenseCount();
        }
        return count;
    }

    public synchronized License[] getLicenses() {
        License[] licenseArray = this.licenses.toArray(new License[this.licenses.size()]);
        if (licenseArray.length == 0 && this.getParent() != null) {
            licenseArray = this.getParent().getLicenses();
        }
        return licenseArray;
    }

    public ProjectObjectModel getParent() {
        return this.parent;
    }

    @Override
    public String getRelativePath() {
        return MavenPathUtils.getPath(this.artifact);
    }

    @Override
    public ResourceType getType() {
        return ResourceType.POM;
    }

    public URL getUrl() throws MalformedURLException {
        return new URL(this.repository.getLocation() + "/" + this.artifact.getRelativePath() + "/" + this.artifact.getFileName());
    }

    public String getVersion() {
        return this.artifact.getVersion();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getGroupId().hashCode();
        result = 31 * result + this.getArtifactId().hashCode();
        result = 31 * result + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        result = 31 * result + Arrays.hashCode(this.getLicenses());
        result = 31 * result + Arrays.hashCode(this.getDependencies());
        return result;
    }

    public boolean hasLicense() {
        boolean flag;
        boolean bl = flag = !this.licenses.isEmpty();
        if (!flag && this.getParent() != null) {
            flag = this.getParent().hasLicense();
        }
        return flag;
    }

    public boolean isAlreadyRead() {
        return this.read;
    }

    @Override
    public Iterator<Artifact> iterator() {
        Iterator<Artifact> iterator = Collections.unmodifiableList(this.dependencies).iterator();
        if (!iterator.hasNext() && this.getParent() != null) {
            iterator = this.getParent().iterator();
        }
        return iterator;
    }

    public void setParent(ProjectObjectModel parent) {
        this.parent = parent;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    void setAlreadyRead(boolean read) {
        this.read = read;
    }
}

