/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.maven;

import jp.sourceforge.talisman.hermes.DomUtils;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;
import jp.sourceforge.talisman.hermes.maven.License;
import jp.sourceforge.talisman.hermes.maven.ProjectObjectModel;
import jp.sourceforge.talisman.hermes.maven.RepositoryIOException;
import jp.sourceforge.talisman.hermes.maven.RepositoryItemMismatchException;
import jp.sourceforge.talisman.hermes.maven.RepositoryItemParser;
import org.w3c.dom.Element;

public class ProjectObjectModelParser
extends RepositoryItemParser {
    private ProjectObjectModel pom;

    public ProjectObjectModelParser(ProjectObjectModel pom) {
        super(pom);
        this.pom = pom;
    }

    @Override
    protected void parseElement(Element root) throws RepositoryIOException {
        Element licenses;
        Element dependencies;
        String version = DomUtils.getContentOfElement(root, "version");
        if (version != null && !this.pom.getVersion().equals(version)) {
            throw new RepositoryItemMismatchException(String.format("expected version <%s>, but <%s>", this.pom.getVersion(), version));
        }
        Element parentTag = DomUtils.getChildElement(root, "parent");
        if (parentTag != null) {
            String groupId = DomUtils.getContentOfElement(parentTag, "groupId");
            String artifactId = DomUtils.getContentOfElement(parentTag, "artifactId");
            String parentVersion = DomUtils.getContentOfElement(parentTag, "version");
            if (groupId != null && artifactId != null && parentVersion != null) {
                this.pom.setParent(new ProjectObjectModel(new Artifact(groupId, artifactId, parentVersion)));
            }
        }
        if ((dependencies = DomUtils.getChildElement(root, "dependencies")) != null) {
            Element[] dependency = DomUtils.getChildElements(dependencies, "dependency");
            for (int i = 0; i < dependency.length; ++i) {
                String artifactId = DomUtils.getContentOfElement(dependency[i], "artifactId");
                String groupId = DomUtils.getContentOfElement(dependency[i], "groupId");
                String dependencyVersion = DomUtils.getContentOfElement(dependency[i], "version");
                String scope = DomUtils.getContentOfElement(dependency[i], "scope");
                String optional = DomUtils.getContentOfElement(dependency[i], "optional");
                Artifact dependencyArtifact = new Artifact(groupId, artifactId, dependencyVersion);
                DependencyScope dependencyScope = DependencyScope.COMPILE;
                if (scope != null) {
                    dependencyScope = DependencyScope.valueOf(scope.toUpperCase());
                }
                dependencyArtifact.setScope(dependencyScope);
                if (optional != null && optional.equalsIgnoreCase("true")) continue;
                this.pom.addDependency(dependencyArtifact);
            }
        }
        if ((licenses = DomUtils.getChildElement(root, "licenses")) != null) {
            Element[] elements = DomUtils.getChildElements(licenses, "license");
            for (int i = 0; i < elements.length; ++i) {
                String name = DomUtils.getContentOfElement(elements[i], "name");
                String url = DomUtils.getContentOfElement(elements[i], "url");
                License license = new License(name, url);
                this.pom.addLicense(license);
            }
        }
    }
}

