/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.ui.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.ui.swing.DependencyPanel;
import jp.sourceforge.talisman.hermes.ui.swing.HermesContextBuilder;

class AddDependencyAction
extends AbstractAction {
    private static final long serialVersionUID = 521638371697820423L;
    private HermesContextBuilder parent;
    private boolean versionFlag = true;

    public AddDependencyAction(HermesContextBuilder parent, boolean flag) {
        this(parent);
        this.versionFlag = flag;
    }

    public AddDependencyAction(HermesContextBuilder parent) {
        super("Add");
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DependencyPanel panel = new DependencyPanel(this.versionFlag);
        int value = JOptionPane.showConfirmDialog(this.parent, panel, "Add new dependency", 2, 3);
        if (value == 0) {
            try {
                Artifact artifact = panel.getDependency();
                if (this.versionFlag) {
                    this.parent.getContext().addDependency(artifact);
                } else {
                    this.parent.getContext().addIgnore(artifact.getGroupId(), artifact.getArtifactId());
                }
            }
            catch (IllegalArgumentException e1) {
                JOptionPane.showMessageDialog(this.parent, e1.getMessage());
            }
        }
    }
}

