/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.talisman.hermes.HermesEvent;
import jp.sourceforge.talisman.hermes.HermesListener;
import jp.sourceforge.talisman.hermes.HermesPercentageListener;
import jp.sourceforge.talisman.hermes.maven.Artifact;

class DelegateHermesPercentageListener
implements HermesListener {
    private HermesPercentageListener listener;
    private Map<Artifact, Integer> fileSizes = new HashMap<Artifact, Integer>();

    public DelegateHermesPercentageListener(HermesPercentageListener listener) {
        this.listener = listener;
    }

    @Override
    public void fileSizeUpdated(HermesEvent e) {
        this.listener.progress(e, (double)e.getSize() / (double)this.fileSizes.get(e.getArtifact()).intValue());
    }

    @Override
    public void finish(HermesEvent e) {
        this.listener.finish(e);
    }

    @Override
    public void fileSizeGotten(HermesEvent e) {
        this.fileSizes.put(e.getArtifact(), e.getSize());
        this.listener.fileSizeGotten(e);
    }

    @Override
    public void targetResolved(HermesEvent e) {
        this.listener.targetResolved(e);
    }

    @Override
    public void downloadDone(HermesEvent e) {
        this.listener.downloadDone(e);
    }

    public HermesPercentageListener getListener() {
        return this.listener;
    }
}

