/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.HermesContextExporter;
import jp.sourceforge.talisman.hermes.HermesContextParser;
import jp.sourceforge.talisman.hermes.InvalidHermesConfigException;
import jp.sourceforge.talisman.hermes.RepositoryScope;
import jp.sourceforge.talisman.hermes.UpdatingLibraryCheckPolicy;
import jp.sourceforge.talisman.hermes.maven.AbstractRepositoryItem;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;
import jp.sourceforge.talisman.hermes.maven.Repository;
import jp.sourceforge.talisman.hermes.ui.swing.ActionDelegateMouseListener;
import jp.sourceforge.talisman.hermes.ui.swing.AddDependencyAction;
import jp.sourceforge.talisman.hermes.ui.swing.AddRepositoryAction;
import jp.sourceforge.talisman.hermes.ui.swing.CurrentDirectoryHandler;
import jp.sourceforge.talisman.hermes.ui.swing.DependencyScopeUpdatingAction;
import jp.sourceforge.talisman.hermes.ui.swing.EditDependencyAction;
import jp.sourceforge.talisman.hermes.ui.swing.EditRepositoryAction;
import jp.sourceforge.talisman.hermes.ui.swing.LoadAction;
import jp.sourceforge.talisman.hermes.ui.swing.NotEditableDefaultTableModel;
import jp.sourceforge.talisman.hermes.ui.swing.RemoveDependencyAction;
import jp.sourceforge.talisman.hermes.ui.swing.RemoveRepositoryAction;
import jp.sourceforge.talisman.hermes.ui.swing.SaveAction;
import jp.sourceforge.talisman.hermes.ui.swing.SetDestinationAction;

public class HermesContextBuilder
extends JPanel {
    private static final long serialVersionUID = -1139978069104398535L;
    private HermesContext context;
    private JComboBox repositoryScopeCombo;
    private JComboBox updatingLibraryCheckPolicyCombo;
    private JCheckBox[] checks = new JCheckBox[DependencyScope.values().length];
    private JTextField destination = new JTextField();
    private DefaultListModel repositoryListModel = new DefaultListModel();
    private JList repositoryList = new JList(this.repositoryListModel);
    private DefaultTableModel dependencyTableModel = new NotEditableDefaultTableModel(new String[]{"Group Id", "Artifact Id", "Version", "Scope"}, 0);
    private JTable dependencyTable = new JTable(this.dependencyTableModel);
    private DefaultTableModel ignoreTableModel = new NotEditableDefaultTableModel(new String[]{"Group Id", "Artifact Id"}, 0);
    private JTable ignoreTable = new JTable(this.ignoreTableModel);
    private JTextArea contextStringArea;
    private CurrentDirectoryHandler handler;
    private transient PropertyChangeListener listener;

    public HermesContextBuilder(String[] args) {
        super(new BorderLayout());
        this.context = this.findContext(args);
        this.handler = new CurrentDirectoryHandler();
        this.handler.addFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "Xml File (*.xml)";
            }
        });
        this.initListener();
        this.initLayout();
        this.updateFields(this.context);
        this.setPreferredSize(new Dimension(800, 500));
        this.setSize(this.getPreferredSize());
    }

    public void setContext(HermesContext context) {
        this.context.removePropertyChangeListener(this.listener);
        this.context = context;
        context.addPropertyChangeListener(this.listener);
        this.updateFields(context);
    }

    public HermesContext getContext() {
        return this.context;
    }

    void updateFields(HermesContext context) {
        this.context = context;
        this.repositoryScopeCombo.setSelectedItem((Object)context.getRepositoryScope());
        this.updatingLibraryCheckPolicyCombo.setSelectedItem((Object)context.getPolicy());
        this.destination.setText(context.getDestination());
        this.repositoryListModel.clear();
        for (Repository repository : context.getRepositories()) {
            this.repositoryListModel.addElement(repository.getName());
        }
        this.dependencyTableModel.setRowCount(0);
        for (Serializable serializable : context.getDependencies()) {
            this.dependencyTableModel.addRow(new Object[]{((AbstractRepositoryItem)serializable).getGroupId(), ((AbstractRepositoryItem)serializable).getArtifactId(), ((Artifact)serializable).getVersion(), ((Artifact)serializable).getScope()});
        }
        this.ignoreTableModel.setRowCount(0);
        for (Serializable serializable : context.getIgnores()) {
            this.ignoreTableModel.addRow(new Object[]{((AbstractRepositoryItem)serializable).getGroupId(), ((AbstractRepositoryItem)serializable).getArtifactId()});
        }
    }

    private HermesContext findContext(String[] args) {
        HermesContext context = null;
        if (args.length > 0 && args[0].endsWith(".xml")) {
            try {
                context = new HermesContextParser().parse(new File(args[0]));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage());
            }
            catch (InvalidHermesConfigException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage());
            }
        }
        if (context == null) {
            context = new HermesContext();
        }
        return context;
    }

    private void initListener() {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HermesContextBuilder.this.updateFields((HermesContext)evt.getSource());
            }
        };
        this.context.addPropertyChangeListener(this.listener);
    }

    private void initLayout() {
        JTabbedPane tab = new JTabbedPane();
        JPanel south = new JPanel(new FlowLayout(1));
        south.add(new JButton(new LoadAction(this, this.handler)));
        south.add(new JButton(new SaveAction(this, this.handler)));
        tab.addTab("default view", this.createDefaultView());
        tab.addTab("xml view", this.createXmlView());
        tab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HermesContextBuilder.this.tabChanged((JTabbedPane)e.getSource());
            }
        });
        this.add((Component)tab, "Center");
        this.add((Component)south, "South");
    }

    private void tabChanged(JTabbedPane tab) {
        String string = this.contextStringArea.getText().trim();
        if (tab.getSelectedIndex() == 1) {
            try {
                StringWriter out = new StringWriter();
                new HermesContextExporter().export(new PrintWriter(out), this.context);
                this.contextStringArea.setText(out.toString());
                out.close();
            }
            catch (IOException e) {
                throw new InternalError(e.getMessage());
            }
        }
        if (string.length() > 0) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(string.getBytes());
                HermesContextParser parser = new HermesContextParser();
                HermesContext context = parser.parse(in);
                if (parser.hasExceptions()) {
                    StringBuilder sb = new StringBuilder();
                    String ln = System.getProperty("line.separator");
                    for (Exception e : parser) {
                        sb.append(e.getLocalizedMessage()).append(ln);
                    }
                    JOptionPane.showMessageDialog(this, new String(sb));
                }
                this.setContext(context);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage());
            }
            catch (InvalidHermesConfigException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage());
            }
        }
    }

    private Component createDefaultView() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.repositoryScopeCombo = new JComboBox();
        for (RepositoryScope repositoryScope : RepositoryScope.values()) {
            this.repositoryScopeCombo.addItem(repositoryScope);
        }
        this.repositoryScopeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HermesContextBuilder.this.getContext().setRepositoryScope((RepositoryScope)((Object)HermesContextBuilder.this.repositoryScopeCombo.getSelectedItem()));
            }
        });
        this.repositoryScopeCombo.setBorder(new TitledBorder("Repository Scope"));
        this.updatingLibraryCheckPolicyCombo = new JComboBox();
        for (Enum enum_ : UpdatingLibraryCheckPolicy.values()) {
            this.updatingLibraryCheckPolicyCombo.addItem(enum_);
        }
        this.updatingLibraryCheckPolicyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HermesContextBuilder.this.getContext().setPolicy((UpdatingLibraryCheckPolicy)((Object)HermesContextBuilder.this.updatingLibraryCheckPolicyCombo.getSelectedItem()));
            }
        });
        this.updatingLibraryCheckPolicyCombo.setBorder(new TitledBorder("Updating Libracy Check Policy"));
        DependencyScope[] scopes = DependencyScope.values();
        JPanel dependencyScopePanel = new JPanel(new GridLayout(1, this.checks.length));
        for (int i = 0; i < scopes.length; ++i) {
            this.checks[i] = new JCheckBox(new DependencyScopeUpdatingAction(this, scopes[i]));
            this.checks[i].setSelected(this.getContext().isInclude(scopes[i]));
            dependencyScopePanel.add(this.checks[i]);
        }
        dependencyScopePanel.setBorder(new TitledBorder("Dependency Scope"));
        JPanel destinationPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        destinationPanel.add((Component)this.destination, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        destinationPanel.add(new JButton(new SetDestinationAction(this, this.handler)));
        this.destination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = HermesContextBuilder.this.destination.getText();
                HermesContextBuilder.this.getContext().setDestination(value);
            }
        });
        destinationPanel.setBorder(new TitledBorder("Destination"));
        EditRepositoryAction editRepositoryAction = new EditRepositoryAction(this, this.repositoryList.getSelectionModel());
        JPanel repositoryListPanel = new JPanel(new BorderLayout());
        JPanel repositoryListButtonPanel = new JPanel(new GridLayout(1, 3));
        repositoryListButtonPanel.add(new JButton(new AddRepositoryAction(this)));
        repositoryListButtonPanel.add(new JButton(editRepositoryAction));
        repositoryListButtonPanel.add(new JButton(new RemoveRepositoryAction(this, this.repositoryList.getSelectionModel())));
        this.repositoryList.addMouseListener(new ActionDelegateMouseListener(editRepositoryAction));
        repositoryListPanel.add((Component)new JScrollPane(this.repositoryList), "Center");
        repositoryListPanel.add((Component)repositoryListButtonPanel, "South");
        repositoryListPanel.setBorder(new TitledBorder("Repository List"));
        EditDependencyAction editDependencyAction = new EditDependencyAction(this, this.dependencyTable.getSelectionModel());
        JPanel dependencyListPanel = new JPanel(new BorderLayout());
        JPanel dependencyTableButtonPanel = new JPanel(new GridLayout(1, 3));
        dependencyTableButtonPanel.add(new JButton(new AddDependencyAction(this)));
        dependencyTableButtonPanel.add(new JButton(editDependencyAction));
        dependencyTableButtonPanel.add(new JButton(new RemoveDependencyAction(this, this.dependencyTable.getSelectionModel())));
        this.dependencyTable.setRowSorter(new TableRowSorter<DefaultTableModel>(this.dependencyTableModel));
        this.dependencyTable.addMouseListener(new ActionDelegateMouseListener(editDependencyAction));
        dependencyListPanel.add((Component)new JScrollPane(this.dependencyTable), "Center");
        dependencyListPanel.add((Component)dependencyTableButtonPanel, "South");
        dependencyListPanel.setBorder(new TitledBorder("Dependency List"));
        EditDependencyAction editIgnoreAction = new EditDependencyAction(this, this.ignoreTable.getSelectionModel(), false);
        JPanel ignoreListPanel = new JPanel(new BorderLayout());
        JPanel ignoreTableButtonPanel = new JPanel(new GridLayout(1, 3));
        ignoreTableButtonPanel.add(new JButton(new AddDependencyAction(this, false)));
        ignoreTableButtonPanel.add(new JButton(editIgnoreAction));
        ignoreTableButtonPanel.add(new JButton(new RemoveDependencyAction(this, this.ignoreTable.getSelectionModel(), false)));
        this.ignoreTable.setRowSorter(new TableRowSorter<DefaultTableModel>(this.ignoreTableModel));
        this.ignoreTable.addMouseListener(new ActionDelegateMouseListener(editIgnoreAction));
        ignoreListPanel.add((Component)new JScrollPane(this.ignoreTable), "Center");
        ignoreListPanel.add((Component)ignoreTableButtonPanel, "South");
        ignoreListPanel.setBorder(new TitledBorder("Ignore List"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.repositoryScopeCombo, gbc);
        gbc.gridy = 1;
        panel.add((Component)this.updatingLibraryCheckPolicyCombo, gbc);
        gbc.gridy = 2;
        panel.add((Component)dependencyScopePanel, gbc);
        gbc.gridy = 3;
        panel.add((Component)destinationPanel, gbc);
        gbc.gridheight = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)repositoryListPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        panel.add((Component)dependencyListPanel, gbc);
        gbc.gridy = 5;
        panel.add((Component)ignoreListPanel, gbc);
        return panel;
    }

    private Component createXmlView() {
        this.contextStringArea = new JTextArea();
        return new JScrollPane(this.contextStringArea);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Hermes Context Builder");
        f.add((Component)new HermesContextBuilder(args), "Center");
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

