package jp.sourceforge.talisman.hermes;

/*
 * $Id: HermesListener.java 198 2009-05-30 14:45:26Z tama3 $
 */

/**
 * This listener interface is for see the progress of downloading.
 * 
 * At first, {@link #targetResolved <code>targetResolved</code>}
 * mehtod is called. Next, following methods are called for each
 * target. {@link #fileSizeGotten <code>fileSizeGotten</code>}, {@link
 * #fileSizeUpdated <code>fileSizeUpdated</code>}, and {@link
 * #downloadDone <code>downloadDone</code>}. The {@link
 * #fileSizeUpdated <code>fileSizeUpdated</code>} method is called
 * several times until {@link #downloadDone <code>downloadDone</code>}
 * method is called.
 * 
 * Finally, {@link #finish <code>finish</code>} method is called and
 * all of online update process is finished.
 *
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public interface HermesListener{
    /**
     * This method is called when updating targets are resolved.
     */
    public void targetResolved(HermesEvent e);

    /**
     * This method is called when size of the one of updating
     * targets is resolved.
     */
    public void fileSizeGotten(HermesEvent e);

    /**
     * This method is called several times until the downloading of
     * the one of updating target is finished.
     */
    public void fileSizeUpdated(HermesEvent e);

    /**
     * This method is called when the downloading of the one of
     * updating target is finished.
     */
    public void downloadDone(HermesEvent e);

    /**
     * This method is called when all of hermes process is finished.
     */
    public void finish(HermesEvent e);
}
