package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: CurrentDirectoryHandler.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class CurrentDirectoryHandler implements Serializable{
    private static final long serialVersionUID = -3424003758492729119L;

    private File currentDirectory;
    private List<FileFilter> filters = new ArrayList<FileFilter>();

    public CurrentDirectoryHandler(){
        this(new File("."));
    }

    public CurrentDirectoryHandler(File currentDirectory){
        this.currentDirectory = currentDirectory;
    }

    public File getCurrentDirectory(){
        return currentDirectory;
    }

    public void setCurrentDirectory(File file){
        if(!file.isDirectory()){
            throw new IllegalArgumentException(file + " is not directory");
        }
        this.currentDirectory = file;
    }

    public void addFileFilter(FileFilter filter){
        filters.add(filter);
    }

    public synchronized FileFilter[] getFileFilters(){
        return filters.toArray(new FileFilter[filters.size()]);
    }

    public synchronized void registerFileFilter(JFileChooser chooser){
        for(FileFilter filter: filters){
            chooser.addChoosableFileFilter(filter);
        }
    }
}
