package jp.sourceforge.talisman.hermes.maven;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectObjectModelTest{
    private ProjectObjectModel pom1;
    private ProjectObjectModel pom2;

    @Before
    public void setUp() throws Exception{
        Artifact artifact1 = new Artifact("jp.sourceforge", "stigmata", "2.0.0");
        pom1 = artifact1.getPom();
        ProjectObjectModelParser parser1 = new ProjectObjectModelParser(pom1);
        parser1.parse(getClass().getResourceAsStream("/repository/jp/sourceforge/stigmata/2.0.0/stigmata-2.0.0.pom"));

        Artifact artifact2 = new Artifact("jp.sourceforge", "stigmata", "2.0.0");
        pom2 = artifact2.getPom();
        ProjectObjectModelParser parser2 = new ProjectObjectModelParser(pom2);
        parser2.parse(getClass().getResourceAsStream("/repository/jp/sourceforge/stigmata/2.0.0/stigmata-2.0.0.pom"));
    }

    @Test
    public void testBasic(){
        Assert.assertFalse(pom1.equals(null));
        Assert.assertEquals(pom1, pom2);
        Assert.assertEquals(pom1.hashCode(), pom2.hashCode());
    }
}
