package jp.sourceforge.talisman.hermes.maven;

/*
 * $Id: RepositoryManagerTest.java 187 2009-05-27 10:09:01Z tama3 $
 */

import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.HermesContextParser;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * 
 * @author Harauki Tamada
 * @version $Revision: 187 $
 */
public class RepositoryManagerTest{
    private HermesContext context;
    private RepositoryManager manager;

    @Before
    public void setUp() throws Exception{
        HermesContextParser parser = new HermesContextParser();
        context = parser.parse(getClass().getResource("/hermes/hermes.xml"));

        // setting actual repository.
        manager = new RepositoryManager(context);
    }

    @Test
    public void testBasic() throws Exception{
        Artifact stigmata1 = manager.findArtifact("jp.sourceforge", "stigmata");

        Assert.assertEquals(stigmata1.getGroupId(), "jp.sourceforge");
        Assert.assertEquals(stigmata1.getArtifactId(), "stigmata");
        Assert.assertEquals(stigmata1.getVersion(), "2.0.0");

        Artifact stigmata2 = manager.findArtifact("jp.naist.se", "stigmata", "1.0.0");

        Assert.assertEquals(stigmata2.getGroupId(), "jp.naist.se");
        Assert.assertEquals(stigmata2.getArtifactId(), "stigmata");
        Assert.assertEquals(stigmata2.getVersion(), "1.0.0");
    }

    @Test
    public void testNotFound() throws Exception{
        Artifact artifact = manager.findArtifact(new Artifact("org.apache.bcel", "bcel"));
        Assert.assertEquals(artifact.getGroupId(), "org.apache.bcel");
        Assert.assertEquals(artifact.getArtifactId(), "bcel");
        Assert.assertEquals(artifact.getVersion(), "5.2");
    }

    @Test
    public void testNotFoundWithVersion() throws Exception{
        Artifact artifact = manager.findArtifact(new Artifact("org.apache.bcel", "bcel", "5.2"));
        Assert.assertEquals(artifact.getGroupId(), "org.apache.bcel");
        Assert.assertEquals(artifact.getArtifactId(), "bcel");
        Assert.assertEquals(artifact.getVersion(), "5.2");
    }
}
