package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: EditRepositoryAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;

import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

import jp.sourceforge.talisman.hermes.maven.Repository;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class EditRepositoryAction extends RemoveRepositoryAction{
    private static final long serialVersionUID = -560079170823032617L;

    public EditRepositoryAction(HermesContextBuilder parent, ListSelectionModel model){
        super("Edit", parent, model);
    }

    @Override
    public void actionPerformed(ActionEvent e){
        Repository repo = getRepository();

        if(repo != null){
            RepositoryPanel panel = new RepositoryPanel(repo);
            int value = JOptionPane.showConfirmDialog(getParent(), panel, "Edit repository", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE);
            if(value == JOptionPane.OK_OPTION){
                try{
                    Repository repo2 = panel.getRepository();
                    if(!repo.getId().equals(repo2.getId())
                            || !repo.getName().equals(repo2.getName())
                            || !repo.getLocation().equals(repo2.getLocation())){
                        getSelectionModel().clearSelection();
                        getContext().removeRepository(repo);
                        getContext().addRepository(repo2);
                    }
                } catch(MalformedURLException e1){
                    JOptionPane.showMessageDialog(getParent(), e1.getLocalizedMessage(), "Input error", JOptionPane.WARNING_MESSAGE);
                }
            }
        }
    }
}
