package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: RepositoryPanel.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import jp.sourceforge.talisman.hermes.maven.Repository;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class RepositoryPanel extends JPanel{
    private static final long serialVersionUID = -4192895265146958177L;

    private JTextField idField;
    private JTextField nameField;
    private JTextField urlField;

    public RepositoryPanel(){
        this("", "", "");
    }

    public RepositoryPanel(Repository repository){
        this(repository.getId(), repository.getName(), repository.getLocation());
    }

    public RepositoryPanel(String id, String name, URL url){
        this(id, name, url.toString());
    }

    public RepositoryPanel(String id, String name, String url){
        idField = new JTextField(id);
        nameField = new JTextField(name);
        urlField = new JTextField(url);

        initLayouts();
    }

    public Repository getRepository() throws MalformedURLException{
        return new Repository(getId(), getName(), new URL(getUrl()));
    }

    public String getId(){
        return idField.getText();
    }

    public String getName(){
        return nameField.getText();
    }

    public String getUrl(){
        return urlField.getText();
    }

    private void initLayouts(){
        GridBagConstraints gbc = new GridBagConstraints();
        setLayout(new GridBagLayout());

        gbc.gridheight = gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.NONE;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(new JLabel("Id"), gbc);
        gbc.gridy = 1;
        add(new JLabel("Name"), gbc);
        gbc.gridy = 2;
        add(new JLabel("Url"), gbc);

        gbc.weightx = 1d;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.gridx = 1;
        gbc.gridy = 0;
        add(idField, gbc);
        gbc.gridy = 1;
        add(nameField, gbc);
        gbc.gridy = 2;
        add(urlField, gbc);
    }
}
