package jp.sourceforge.talisman.hermes.maven;

/*
 * $Id: MetadataParserTest.java 198 2009-05-30 14:45:26Z tama3 $
 */
import java.util.Iterator;

import jp.sourceforge.talisman.hermes.ResourceType;
import jp.sourceforge.talisman.hermes.maven.Metadata;
import jp.sourceforge.talisman.hermes.maven.MetadataParser;
import jp.sourceforge.talisman.hermes.maven.RepositoryItemMismatchException;

import org.junit.Assert;
import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public class MetadataParserTest{
    @Test
    public void testBasic() throws Exception{
        Metadata meta = new Metadata("jp.sourceforge", "stigmata");
        MetadataParser parser = new MetadataParser(meta);
        parser.parse(getClass().getResourceAsStream("/repository/jp/sourceforge/stigmata/maven-metadata.xml"));

        Assert.assertEquals(meta.getFileName(), "maven-metadata.xml");
        Assert.assertEquals(meta.getRelativePath(), "jp/sourceforge/stigmata");
        Assert.assertEquals(meta.getType(), ResourceType.XML);

        Assert.assertEquals(meta.getArtifactId(), "stigmata");
        Assert.assertEquals(meta.getGroupId(), "jp.sourceforge");
        Assert.assertEquals(meta.getLastUpdated(), "20081210074248");
        Assert.assertEquals(meta.getLatestVersion(), "2.1.0");
        Assert.assertEquals(meta.getVersionCount(), 3);

        Iterator<String> versionsIterator = meta.iterator();
        Assert.assertEquals(versionsIterator.next(), "1.0.0");
        Assert.assertEquals(versionsIterator.next(), "2.0.0");
        Assert.assertEquals(versionsIterator.next(), "2.1.0");
        Assert.assertFalse(versionsIterator.hasNext());

        Assert.assertTrue(meta.contains("1.0.0"));
        Assert.assertTrue(meta.contains("2.0.0"));
        Assert.assertTrue(meta.contains("2.1.0"));
        Assert.assertFalse(meta.contains("1.1.0"));
    }

    @Test(expected=RepositoryItemMismatchException.class)
    public void testMismatchArtifact() throws Exception{
        Metadata meta = new Metadata("jp.sourceforge", "NOTstigmata");
        MetadataParser parser = new MetadataParser(meta);
        parser.parse(getClass().getResourceAsStream("/repository/jp/sourceforge/stigmata/maven-metadata.xml"));
    }

    @Test(expected=RepositoryItemMismatchException.class)
    public void testMismatchGroupId() throws Exception{
        Metadata meta = new Metadata("jp.naist.se", "stigmata");
        MetadataParser parser = new MetadataParser(meta);
        parser.parse(getClass().getResourceAsStream("/repository/jp/sourceforge/stigmata/maven-metadata.xml"));
    }
}
