package jp.sourceforge.talisman.hermes;

/*
 * $Id: HermesEvent.java 198 2009-05-30 14:45:26Z tama3 $
 */

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.talisman.hermes.maven.Artifact;

/**
 * Event class.
 * 
 * @author Harauki Tamada
 * @version $Revision: 198 $
 */
public class HermesEvent{
    /**
     * Event Id.
     */
    public static enum Id{
        TARGET_RESOLVED, FILE_SIZE_GOTTEN, FILE_SIZE_UPDATED, DOWNLOAD_DONE, FINISH
    }

    /**
     * Event Id.
     */
    private Id id;

    private List<Artifact> artifacts;
    private Artifact artifact;
    private int size;

    /**
     * Constructor for {@link Id#FINISH <code>FINISH</code>}.
     */
    public HermesEvent(Id id){
        this.id = id;
    }

    /**
     * Constructor for {@link Id#TARGET_RESOLVED <code>TARGET_RESOLVED</code>}.
     */
    public HermesEvent(Id id, Artifact[] initialArtifacts){
        this(id);
        artifacts = new ArrayList<Artifact>();
        for(Artifact artifact: initialArtifacts){
            artifacts.add(artifact);
        }
    }

    /**
     * Constructor for {@link Id#DOWNLOAD_DONE
     * <code>DOWNLOAD_DONE</code>}.
     */
    public HermesEvent(Id id, Artifact artifact){
        this(id);
        this.artifact = artifact;
    }

    /**
     * Constructor for {@link Id#FILE_SIZE_GOTTEN
     * <code>FILE_SIZE_GOTTEN</code>}, {@link Id#FILE_SIZE_UPDATED
     * <code>FILE_SIZE_UPDATED</code>},
     */
    public HermesEvent(Id id, Artifact artifact, int size){
        this(id, artifact);
        this.size = size;
    }

    /**
     * Returns event id.
     */
    public Id getId(){
        return id;
    }

    /**
     * This method returns target artifacts and this method is
     * available on {@link Id#TARGET_RESOLVED
     * <code>TARGET_RESOLVED</code>}.
     */
    public synchronized Artifact[] getArtifacts(){
        if(id != Id.TARGET_RESOLVED){
            throw new IllegalStateException("This method is available on TARGET_RESOLVED");
        }
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    /**
     * Returns current target.  This method is available on {@link
     * Id#FILE_SIZE_GOTTEN <code>FILE_SIZE_GOTTEN</code>}, {@link
     * Id#FILE_SIZE_UPDATED <code>FILE_SIZE_UPDATED</code>} and {@link
     * Id#DOWNLOAD_DONE <code>DOWNLOAD_DONE</code>}.
     */
    public Artifact getArtifact(){
        if(id != Id.FILE_SIZE_UPDATED || id != Id.FILE_SIZE_GOTTEN || id != Id.DOWNLOAD_DONE){
            throw new IllegalStateException("this method is available on FILE_SIZE_GOTTEN or FILE_SIZE_UPDATED");
        }
        return artifact;
    }

    /**
     * returns file size on {@link Id#FILE_SIZE_GOTTEN}, and current
     * downloaded size on {@link Id#FILE_SIZE_UPDATED}.
     */
    public int getSize(){
        if(id != Id.FILE_SIZE_UPDATED || id != Id.FILE_SIZE_GOTTEN){
            throw new IllegalStateException("this method is available on FILE_SIZE_GOTTEN or FILE_SIZE_UPDATED");
        }
        return size;
    }
}
