package jp.sourceforge.talisman.hermes.maven;

/*
 * $Id: MetadataParser.java 174 2009-05-18 02:42:13Z tama3 $
 */

import jp.sourceforge.talisman.hermes.DomUtils;

import org.w3c.dom.Element;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 174 $
 */
public class MetadataParser extends RepositoryItemParser{
    private Metadata metadata;

    public MetadataParser(Metadata metadata){
        super(metadata);
        this.metadata = metadata;
    }

    protected void parseElement(Element root) throws RepositoryIOException{
        Element versioningElem = DomUtils.getChildElement(root, "versioning");
        if(versioningElem != null){
            Element[] versions = DomUtils.getChildElements(versioningElem, "versions/version");
            for(int i = 0; i < versions.length; i++){
                metadata.addVersion(DomUtils.getContentOfElement(versions[i]));
            }

            Element lastUpdatedElement = DomUtils.getChildElement(versioningElem, "lastUpdated");
            if(lastUpdatedElement != null){
                metadata.setLastUpdated(DomUtils.getContentOfElement(lastUpdatedElement));
            }
        }
    }
}
