package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: AddDependencyAction.java 189 2009-05-28 03:41:13Z tama3 $
 */

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import jp.sourceforge.talisman.hermes.maven.Artifact;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 189 $
 */
class AddDependencyAction extends AbstractAction{
    private static final long serialVersionUID = 521638371697820423L;

    private HermesContextBuilder parent;
    private boolean versionFlag = true;

    public AddDependencyAction(HermesContextBuilder parent, boolean flag){
        this(parent);
        this.versionFlag = flag;
    }

    public AddDependencyAction(HermesContextBuilder parent){
        super("Add");
        this.parent = parent;
    }

    public void actionPerformed(ActionEvent e){
        DependencyPanel panel = new DependencyPanel(versionFlag);
        int value = JOptionPane.showConfirmDialog(
            parent, panel, "Add new dependency", 
            JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE
        );
        if(value == JOptionPane.OK_OPTION){
            try{
                Artifact artifact = panel.getDependency();
                if(versionFlag){
                    parent.getContext().addDependency(artifact);
                }
                else{
                    parent.getContext().addIgnore(artifact.getGroupId(), artifact.getArtifactId());
                }
            } catch(IllegalArgumentException e1){
                JOptionPane.showMessageDialog(parent, e1.getMessage());
            }
        }
    }
}
