package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: RemoveDependencyAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.Component;
import java.awt.event.ActionEvent;

import javax.swing.ListSelectionModel;

import jp.sourceforge.talisman.hermes.HermesContext;
import jp.sourceforge.talisman.hermes.maven.Artifact;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class RemoveDependencyAction extends SelectedAction{
    private static final long serialVersionUID = 2824865599779565655L;

    private HermesContextBuilder parent;
    private boolean versionFlag;

    public RemoveDependencyAction(HermesContextBuilder parent, ListSelectionModel model, boolean versionFlag){
        this(parent, model);
        this.versionFlag = versionFlag;
    }

    public RemoveDependencyAction(HermesContextBuilder parent, ListSelectionModel model){
        this("Remove", parent, model);
     }

    public RemoveDependencyAction(String name, HermesContextBuilder parent, ListSelectionModel model){
        this(name, parent, model, true);
    }

    public RemoveDependencyAction(String name, HermesContextBuilder parent, ListSelectionModel model, boolean versionFlag){
        super(name, model);
        this.parent = parent;
        this.versionFlag = versionFlag;
    }

    Component getParent(){
        return parent;
    }

    HermesContext getContext(){
        return parent.getContext();
    }

    boolean isIncludeVersion(){
        return versionFlag;
    }

    Artifact getDependency(){
        int index = getSelectionModel().getMinSelectionIndex();
        Artifact[] artifacts = getContext().getDependencies();
        if(index >= 0 && artifacts.length > index){
            return artifacts[index];
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e){
        Artifact artifact = getDependency();
        if(artifact != null){
            getContext().removeDependency(artifact);
        }
    }
}
