package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: SaveAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import jp.sourceforge.talisman.hermes.HermesContextExporter;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class SaveAction extends AbstractAction{
    private static final long serialVersionUID = -1231038425322405695L;

    private HermesContextBuilder parent;
    private CurrentDirectoryHandler handler;

    public SaveAction(HermesContextBuilder parent, CurrentDirectoryHandler handler){
        super("Save");
        this.parent = parent;
        this.handler = handler;
    }

    public void actionPerformed(ActionEvent e){
        JFileChooser chooser = new JFileChooser(handler.getCurrentDirectory());
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        handler.registerFileFilter(chooser);

        int value = chooser.showSaveDialog(parent);
        if(value == JFileChooser.APPROVE_OPTION){
            handler.setCurrentDirectory(chooser.getCurrentDirectory());
            File target = chooser.getSelectedFile();
            try{
                new HermesContextExporter().export(target, parent.getContext());
            } catch(IOException e1){
                JOptionPane.showMessageDialog(parent, e1.getMessage());
            }
        }
    }
}
