package jp.sourceforge.talisman.hermes.maven;

/*
 * $Id: MetadataTest.java 198 2009-05-30 14:45:26Z tama3 $
 */

import org.junit.Assert;
import org.junit.Test;

import jp.sourceforge.talisman.hermes.ResourceType;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public class MetadataTest{
    @Test
    public void testBasic() throws Exception{
        Metadata meta = new Metadata("jp.sourceforge", "stigmata");

        Assert.assertEquals(meta.getType(), ResourceType.XML);
        Assert.assertEquals(meta.getRelativePath(), "jp/sourceforge/stigmata");
        Assert.assertEquals(meta.getFileName(), "maven-metadata.xml");

        meta.addVersion("2.1.0");
        meta.addVersion("1.0.0");

        Assert.assertEquals(meta.getLatestVersion(), "2.1.0");
        Assert.assertEquals(meta.getVersionCount(), 2);

        meta.addVersion("2.2.0-SNAPSHOT");
        Assert.assertEquals(meta.getLatestVersion(), "2.1.0");
        Assert.assertEquals(meta.getVersionCount(), 3);
    }
}

