class TestEditingContextBasic < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new MODELS
		@ec  = @app.create_editing_context

		@data_cd = {'title' => 'testtitle', 'artist' => 'testartist', 'release' => 2000}
	end

	def test_insert_object
		assert_equal(0, @ec.inserted_objects.size)

		# inserts a new object
		object = @ec.create 'cd'
		assert_equal(1, @ec.inserted_objects.size)
		assert_not_nil @ec.gid(object)

		# re-inserts the object (isn't inserted)
		@ec.insert object
		assert_equal(1, @ec.inserted_objects.size)
		assert_not_nil @ec.gid(object)
		@ec.delete object

		# inserts the object after deleted (offset)
		qualifier = Qualifier.format ''
		fetchspec = FetchSpec.new('cd', qualifier)
		fetchspec.limit = 1
		object = @ec.fetch(fetchspec).first
		@ec.delete object
		@ec.insert object
		assert_equal(0, @ec.inserted_objects.size)
		assert_nil @ec.gid(object)
	end

	def test_delete_object
		qualifier = Qualifier.format ''
		fetchspec = FetchSpec.new('cd', qualifier)
		fetchspec.limit = 1
		object = @ec.fetch(fetchspec).first

		# deletes the object
		@ec.delete object
		assert_equal(1, @ec.deleted_objects.size)

		# re-deletes the object (isn't deleted)
		@ec.delete object
		assert_equal(1, @ec.deleted_objects.size)

		# deletes the object after inserted (offset)
		@ec.insert object
		@ec.insert object
		@ec.delete object
		assert_equal(0, @ec.deleted_objects.size)
		assert_nil @ec.gid(object)
	end

	def test_objects_when_save_failed
		object1    = @ec.create 'Book' # expects success
		object2    = @ec.create 'Book' # expects error
		test_title = 'test_objects_when_save_failed'
		data_book  = {'title' => test_title}
		object1.take_values data_book

		# check size of inserted objects for save before and after
		assert_equal(2, @ec.inserted_objects.size)
		assert_raises(ValidationError) { @ec.save }
		assert_equal(2, @ec.inserted_objects.size)

		# check the object1 isn't registed
		qualifier  = Qualifier.new_with_format('title == %@', [test_title])
		fetch_spec = FetchSpec.new('Book', qualifier)
		objects    = @ec.fetch fetch_spec
		assert_equal(true, objects.empty?)
	end

end


class TestSharedEditingContext < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new MODELS
		@sec = @app.shared_editing_context
	end

	def test_save
		@sec.create 'Book'
		assert_raises(RuntimeError) { @sec.save }
	end
end