class TestModel < Test::Unit::TestCase
	include TapKit

	def setup
		@model = Model.new MODEL2
	end

	def test_load
		ex_path    = MODEL2
		ex_name    = 'relationship_entity.yaml'
		ex_adapter = 'MySQL'

		assert_equal(ex_name, @model.name)
		assert_equal(ex_path, @model.path)
		assert_equal(ex_adapter, @model.adapter_name)
	end

	def test_connection
		ex_connection = { 'url'      => 'dbi:Mysql:examples',
		                  'user'     => 'mysql',
		                  'password' => 'mysql' }
		assert_equal(ex_connection, @model.connection)
	end

	def test_entity_names
		ex_names = ['Book', 'Publisher']
		assert_equal(ex_names, @model.entity_names)
	end

	def test_entity
		ex_name = 'Book'
		entity  = @model.entity ex_name
		assert_equal(ex_name, entity.name)
	end

	def test_validate_required_attributes
		model = Model.new
		assert_raises(ValidationError) { model.validate_required_attributes }
	end

	def test_to_yaml
		expected = YAML::load(File.open(MODEL2).read).to_yaml(:SortKeys=>true)
		app = Application.new [MODEL2]
		model = app.model MODEL2
		assert_equal(expected, model.to_yaml)
	end
end


# add, remove, entities, entity, model, models
class TestModelGroup < Test::Unit::TestCase
	include TapKit

	def setup
		@app   = Application.new MODELS
		@group = @app.model_group
	end

	# add(model, path), remove
	def test_set
		# add
		model = Model.new
		path  = MODEL1
		@group.add model
		@group.add path
		assert_equal(5, @group.models.size)

		# remove
		@group.remove model
		@group.remove @group.model(path)
		assert_equal(3, @group.models.size)
	end

	def test_entities
		expected = ['cd', 'Book', 'Publisher', 'Mapping']
		keys = []
		@group.entities.each do |entity|
			keys << entity.name
		end
		assert_equal(expected, keys)
	end

	def test_entity
		name = 'Book'
		assert_equal(name, @group.entity(name).name)
	end

	def test_model_names
		expected = ['single_entity.yaml', 'relationship_entity.yaml', 'mapping.yaml']
		assert_equal(expected, @group.model_names)
	end

	def test_models
		expected = ['single_entity.yaml', 'relationship_entity.yaml', 'mapping.yaml']
		names = []
		@group.models.each do |model|
			names << model.name
		end
		assert_equal(expected, names)
	end

	# name, path
	def test_model
		model1 = @group.model 'single_entity.yaml'
		model2 = @group.model MODEL1
		assert_not_nil model1
		assert_not_nil model2
		assert_equal(model1, model2)
	end

end
