unit Base_Publisher;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, Provider, DBClient, DBLocal, DBLocalI,
  MainDatastore, IB, IBErrorCodes, IBSQL, IBDatabase, Misc_Utilities;

type
  TPublisherTemplate = class(TForm)
    Transaction: TIBTransaction;
    Query: TIBSQL;

    bvlBorder: TBevel;

    btnOK: TButton;
    btnCancel: TButton;

    procedure Form_Create(Sender: TObject);
    procedure Form_Destroy(Sender: TObject);
    procedure Form_Show(Sender: TObject);
    procedure Form_CloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnOK_Click(Sender: TObject);
  private
    { Private 錾 }
    FErrorMessages : TStrings;

    function VerifyError() : Boolean;
  protected
    { Protected 錾 }

    procedure BeforePopup(); virtual; abstract;
    procedure AfterPopup(); virtual; abstract;

    property ErrorMessages : TStrings read FErrorMessages;

  public
    { Public 錾 }
    constructor Prepare;

    procedure Popup();
  end;

var
  PublisherTemplate: TPublisherTemplate;

implementation

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPublisherTemplate.Prepare;
begin
	inherited Create( Screen.ActiveForm);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TPublisherTemplate.VerifyError() : Boolean;
begin
	if FErrorMessages.Count > 0 then
	begin
		ShowMessage( FErrorMessages.Text);
		FErrorMessages.Clear;
		result := false;
	end
	else
		result := true;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPublisherTemplate.Popup();
begin
	try
		try
			Transaction.StartTransaction;

			BeforePopup; if not VerifyError then exit;

			if ShowModal() <> mrOk then Transaction.Rollback else Transaction.Commit;

		except
			on err : EIBInterBaseError do
			begin
				if Transaction.InTransaction then Transaction.Rollback;
				case err.IBErrorCode of
				isc_lock_conflict : ShowMessage( '֘Af[^̃Rs[^ŎgpłB');
				else		    ShowMessage( err.Message);
				end;
			end;
			on err : Exception do
			begin
				if Transaction.InTransaction then Transaction.Rollback;
				ShowMessage( err.Message);
			end;
		end;
	finally
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPublisherTemplate.Form_Create(Sender: TObject);
begin
	FErrorMessages := TStringList.Create;
end;

procedure TPublisherTemplate.Form_Destroy(Sender: TObject);
begin
	FErrorMessages.Free;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPublisherTemplate.Form_Show(Sender: TObject);
begin
	ClientWidth := btnCancel.Left + btnCancel.Width + 14;
	ClientHeight := btnCancel.Top + btnCancel.Height + 8;
end;

procedure TPublisherTemplate.Form_CloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	CanClose := VerifyError;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPublisherTemplate.btnOK_Click(Sender: TObject);
begin
	AfterPopup;
end;

end.
