unit Base_Report;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, FlexReport, StdCtrls, ExtCtrls, Printers, ComCtrls, ToolWin,
  Buttons, Math, CommDlg;

type
  TReportTemplate = class(TForm)
    Report: TFlexReport;

    ReportPages: TPageControl;

    pagePreview: TTabSheet;
    boxPreview: TScrollBox;
    pnlPreview: TPanel;
    pnlShadow: TPanel;
    pnlPaper: TPanel;
    PreviewImage: TImage;

    pageDesign: TTabSheet;
    ReportBox: TScrollBox;
    Paper: TFlexReportPaper;

    pnlController: TPanel;

    radShowWholeHeight: TRadioButton;
    radShowWholeWidth: TRadioButton;

    pnlPageSelector: TPanel;
    btnFirstPage: TSpeedButton;
    btnPrevPage: TSpeedButton;
    btnNextPage: TSpeedButton;
    btnLastPage: TSpeedButton;

    btnFax: TSpeedButton;
    btnPrint: TSpeedButton;
    btnClose: TSpeedButton;

    PrinterSetup: TPrintDialog;

    procedure Form_Show(Sender: TObject);
    procedure PreviewSizeAdjuster_Click(Sender: TObject);
    procedure boxPreview_Resize(Sender: TObject);

    procedure btnFirstPage_Click(Sender: TObject);
    procedure btnPrevPage_Click(Sender: TObject);
    procedure btnNextPage_Click(Sender: TObject);
    procedure btnLastPage_Click(Sender: TObject);

    procedure btnFax_Click(Sender: TObject);
    procedure btnPrint_Click(Sender: TObject);
    procedure btnClose_Click(Sender: TObject);

    procedure PreviewImage_MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PreviewImage_MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PreviewImage_MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);

    procedure Report_BeforePage(Sender: TObject);
  private
    { Private 錾 }
    FCurrentPage : Integer;
    FDragCenter : Integer;

    procedure SetCurrentPage( APageIndex : Integer);

    procedure PublishToPrinter( pageFrom, pageTo : Integer);
    procedure PublishToFacsimile( RecipientName, RecipientNumber, SenderCompany : String);
  protected
    { Protected 錾 }
    property CurrentPage : Integer read FCurrentPage write SetCurrentPage;
  public
    { Public 錾 }
    procedure Facsimile( RecipientName, RecipientNumber, SenderCompany : String);
    procedure Printout;
    procedure Preview;
  end;

var
  ReportTemplate: TReportTemplate;

implementation

{$R *.dfm}

uses Misc_PageIndicator, Misc_WinFax, MainDatastore, Chooser_FaxNumber;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReportTemplate.SetCurrentPage( APageIndex : Integer);
begin
	FCurrentPage := Max( 0, Min( APageIndex, Report.PageCount - 1));

	if Report.PageCount > 0 then
	begin
		PreviewImage.Picture.Assign( Report.PageMetafiles[ CurrentPage]);
		pagePreview.Caption := Format( '%d y[W / %d y[W', [ CurrentPage + 1, Report.PageCount]);
	end
	else
		pagePreview.Caption := 'Ȃ';

	PreviewSizeAdjuster_Click( self);

	btnFirstPage.Enabled := CurrentPage > 0;
	btnPrevPage.Enabled := CurrentPage > 0;
	btnNextPage.Enabled := CurrentPage < Report.PageCount - 1;
	btnLastPage.Enabled := CurrentPage < Report.PageCount - 1;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReportTemplate.PublishToPrinter( pageFrom, pageTo : Integer);
var
	PaperRect : TRect;
	PageIndex : Integer;
begin
	if Report.PageCount = 0 then exit;

	Printer.Title := Caption;
	Printer.BeginDoc;
	PaperRect.Left := - GetDeviceCaps( Printer.Canvas.Handle, PHYSICALOFFSETX);
	PaperRect.Top := - GetDeviceCaps( Printer.Canvas.Handle, PHYSICALOFFSETY);
	PaperRect.Right := Printer.PageWidth - PaperRect.Left;
	PaperRect.Bottom := Printer.PageHeight - PaperRect.Top;
	for PageIndex := 0 to Report.PageCount - 1 do
	begin
		if ( pageFrom <= PageIndex + 1) and ( PageIndex + 1 <= pageTo) then
		begin
			if PageIndex + 1 <> pageFrom then Printer.NewPage;
			Printer.Canvas.StretchDraw( PaperRect, Report.PageMetafiles[ PageIndex]);
		end;
	end;
	Printer.EndDoc;
end;

procedure TReportTemplate.PublishToFacsimile( RecipientName, RecipientNumber, SenderCompany : String);
var
	Fax : TCanvas;
	PaperRect : TRect;
	PageIndex : Integer;
begin
	if Report.PageCount = 0 then exit;

	Fax := CreateFaxCanvas( Caption, RecipientName, RecipientNumber, SenderCompany, Paper.Orientation);
	if Fax = nil then
	begin
		ShowMessage( 'FAXfoCX̏Ɏs܂B');
		exit;
	end;
	// create fax canvas

	try
		PaperRect.Left := - GetDeviceCaps( Fax.Handle, PHYSICALOFFSETX);
		PaperRect.Top := - GetDeviceCaps( Fax.Handle, PHYSICALOFFSETY);
		PaperRect.Right := GetDeviceCaps( Fax.Handle, PHYSICALWIDTH) - PaperRect.Left;
		PaperRect.Bottom := GetDeviceCaps( Fax.Handle, PHYSICALHEIGHT) - PaperRect.Top;

		for PageIndex := 0 to Report.PageCount - 1 do
		begin
			if PageIndex > 0 then StartPage( Fax.Handle);
			Fax.StretchDraw( PaperRect, Report.PageMetafiles[ PageIndex]);
		end;
		EndDoc( Fax.Handle);
	finally
		DeleteFaxCanvas( Fax);
	end;
end;



{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReportTemplate.Facsimile( RecipientName, RecipientNumber, SenderCompany : String);
begin
	Report.Print( Paper);
	if Report.PageCount = 0 then exit;
	// generate on-memory printout

	PublishToFacsimile( RecipientName, RecipientNumber, SenderCompany);
	Release;
end;

procedure TReportTemplate.Printout;
var
	Device, Driver, Port : array[ 0..255] of Char;
	hDevMode : THandle;
	PDevMode : ^DevMode;
begin
	Report.Print( Paper);
	if Report.PageCount = 0 then exit;
	// generate on-memory printout

	Printer.GetPrinter( Device, Driver, Port, hDevMode);
	if hDevMode <> 0 then
	begin
		pDevMode := GlobalLock( hDevMode);
		if pDevMode <> nil then
		begin
			pDevMode^.dmFields := pDevMode^.dmFields or DM_PAPERSIZE or DM_ORIENTATION;
			case Paper.PaperForm of
			pfA5 : pDevMode^.dmPaperSize := DMPAPER_A5;
			pfA4 : pDevMode^.dmPaperSize := DMPAPER_A4;
			pfA3 : pDevMode^.dmPaperSize := DMPAPER_A3;
			pfB5 : pDevMode^.dmPaperSize := DMPAPER_B5;
			pfB4 : pDevMode^.dmPaperSize := DMPAPER_B4;
			else
				pDevMode^.dmFields := pDevMode^.dmFields or DM_PAPERWIDTH or DM_PAPERLENGTH;
				pDevMode^.dmPaperSize := DMPAPER_USER;
				pDevMode^.dmPaperWidth := Paper.PaperWidth * 10;
				pDevMode^.dmPaperLength := Paper.PaperHeight * 10;
			end;

			case Paper.Orientation of
			poPortrait : pDevMode^.dmOrientation := DMORIENT_PORTRAIT;
			poLandscape : pDevMode^.dmOrientation := DMORIENT_LANDSCAPE;
			end;

			GlobalUnlock( hDevMode);
			Printer.SetPrinter( Device, Driver, Port, hDevMode);
		end;
	end;
	// setup printer

	PublishToPrinter( 1, Report.PageCount);
	Release;
end;

procedure TReportTemplate.Preview;
begin
	ShowModal;
	Release;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReportTemplate.Form_Show(Sender: TObject);
begin
	pageDesign.TabVisible := false;

	PageIndicator.Visible := true;
	Report.Print( Paper);
	PageIndicator.Visible := false;

	if Report.PageCount = 0 then
	begin
		btnFax.Enabled := false;
		btnPrint.Enabled := false;
		pnlPreview.Visible := false;
	end
	else
	begin
		btnFax.Enabled := IsWinFaxAvailable();
		pnlPreview.Visible := true;
	end;

	btnFirstPage.Click;
end;

procedure TReportTemplate.PreviewSizeAdjuster_Click(Sender: TObject);
var
	PreviewWidth, PreviewHeight : Integer;
begin
	if Report.PageCount = 0 then exit;

	boxPreview.DisableAutoRange;

	if radShowWholeWidth.Checked then
	begin
		PreviewWidth := boxPreview.Width - 96;
		PreviewHeight := MulDiv(
			PreviewWidth - 8,
			Report.PageMetafiles[ CurrentPage].MMHeight,
			Report.PageMetafiles[ CurrentPage].MMWidth
		) + 8;
	end
	else
	begin
		PreviewHeight := boxPreview.Height - 96;
		PreviewWidth := MulDiv(
			PreviewHeight - 8,
			Report.PageMetafiles[ CurrentPage].MMWidth,
			Report.PageMetafiles[ CurrentPage].MMHeight
		);
	end;

	pnlPreview.SetBounds(
		Max( 16, ( boxPreview.Width - PreviewWidth) div 2) - boxPreview.HorzScrollBar.Position,
		Max( 16, ( boxPreview.Height - PreviewHeight) div 2) - boxPreview.VertScrollBar.Position,
		PreviewWidth,
		PreviewHeight
	);

	boxPreview.EnableAutoRange;
end;

procedure TReportTemplate.boxPreview_Resize(Sender: TObject);
begin
	PreviewSizeAdjuster_Click( self);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReportTemplate.btnFirstPage_Click(Sender: TObject);
begin
	CurrentPage := 0;
end;

procedure TReportTemplate.btnPrevPage_Click(Sender: TObject);
begin
	CurrentPage := CurrentPage - 1;
end;

procedure TReportTemplate.btnNextPage_Click(Sender: TObject);
begin
	CurrentPage := CurrentPage + 1;
end;

procedure TReportTemplate.btnLastPage_Click(Sender: TObject);
begin
	CurrentPage := Report.PageCount - 1;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReportTemplate.btnFax_Click(Sender: TObject);
var
	strFaxNumber : String;
begin
	if not ChooseFaxNumber( DataStore.MainTransaction, strFaxNumber) then exit;

	PublishToFacsimile( Caption, strFaxNumber, 'k');
	Close;
end;

procedure TReportTemplate.btnPrint_Click(Sender: TObject);
begin
	Printer.Orientation := Paper.Orientation;
	PrinterSetup.FromPage := 1;
	PrinterSetup.ToPage := Report.PageCount;
	PrinterSetup.FromPage := 1;
	PrinterSetup.MaxPage := Report.PageCount;

	if not PrinterSetup.Execute then exit;

	PublishToPrinter( PrinterSetup.FromPage, PrinterSetup.ToPage);
	Close;
end;

procedure TReportTemplate.btnClose_Click(Sender: TObject);
begin
	Close;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReportTemplate.PreviewImage_MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	SetCaptureControl( PreviewImage);
	FDragCenter := boxPreview.VertScrollBar.Position + Mouse.CursorPos.Y;
end;

procedure TReportTemplate.PreviewImage_MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
	if GetCaptureControl = PreviewImage then
	begin
		boxPreview.VertScrollBar.Position := FDragCenter - Mouse.CursorPos.Y;
	end;
end;

procedure TReportTemplate.PreviewImage_MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	SetCaptureControl( nil);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TReportTemplate.Report_BeforePage(Sender: TObject);
begin
	printif( ( not Visible) or PageIndicator.Visible);
	PageIndicator.PageNumber := Report.PageNumber;
	Application.ProcessMessages;
end;

end.
