unit Base_Workspace;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, SyncObjs, DateUtils,
  Menus, Misc_Constants, Misc_Utilities;

type
  TMenuRegistrar = procedure ( Caption : String; Handler : TNotifyEvent; Enabled : Boolean) of object;

  TWorkspaceTemplate = class(TForm)
    EventListener: TIBEvents;
    EventTimer: TTimer;

    procedure Form_Create(Sender: TObject);
    procedure Form_Close(Sender: TObject; var Action: TCloseAction);
    procedure Form_Destroy(Sender: TObject);
    procedure Form_Required(Sender: TObject);

    procedure EventListener_EventAlert(Sender: TObject; EventName: String; EventCount: Integer; var CancelAlerts: Boolean);
    procedure EventTimer_Timer(Sender: TObject);

    procedure WMSysCommand(var Message: TWMSYSCOMMAND); message WM_SYSCOMMAND;

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); virtual;

  private
    { Private 錾 }
    EventQueue : TStringList;
  protected
    { Protected 錾 }
    function Happened( eventName : String) : Boolean;

    procedure BeforePopup(); virtual; abstract;
    procedure AfterPopup(); virtual; abstract;

    procedure AfterNotify(); virtual;
  public
    { Public 錾 }
  end;

  CWorkspaceTemplate = class of TWorkspaceTemplate;

var
  WorkspaceTemplate: TWorkspaceTemplate;

implementation

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TWorkspaceTemplate.Happened( eventName : String) : Boolean;
begin
	result := EventQueue.IndexOf( eventName) >= 0;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TWorkspaceTemplate.AfterNotify();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TWorkspaceTemplate.Form_Create(Sender: TObject);
begin
	EventQueue := TStringList.Create;
	EventQueue.CaseSensitive := false;
	EventListener.RegisterEvents;

	BeforePopup;
end;

procedure TWorkspaceTemplate.Form_Close(Sender: TObject; var Action: TCloseAction);
begin
	Release;
end;

procedure TWorkspaceTemplate.Form_Destroy(Sender: TObject);
begin
	AfterPopup;

	EventListener.UnRegisterEvents;
	EventQueue.Free;
end;

procedure TWorkspaceTemplate.Form_Required(Sender: TObject);
begin
	Show;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TWorkspaceTemplate.EventListener_EventAlert(Sender: TObject; EventName: String; EventCount: Integer; var CancelAlerts: Boolean);
begin
	if EventQueue.IndexOf( EventName) < 0 then EventQueue.Add( EventName);
end;

procedure TWorkspaceTemplate.EventTimer_Timer(Sender: TObject);
var
	index : Integer;
begin
	if not EventListener.Registered then
	begin
		EventListener.RegisterEvents;
		for index := 0 to EventListener.Events.Count - 1 do
			if EventQueue.IndexOf( EventListener.Events.Strings[ index]) < 0 then
				EventQueue.Add( EventListener.Events.Strings[ index]);
	end;

	if Screen.ActiveForm <> Application.MainForm.ActiveMDIChild then exit;

	if EventQueue.Count > 0 then
	begin
		AfterNotify;
		EventQueue.Clear;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TWorkspaceTemplate.WMSysCommand(var Message: TWMSYSCOMMAND);
begin
	case Message.CmdType of
	SC_NEXTWINDOW : Screen.ActiveForm.Perform( CM_DIALOGKEY, VK_TAB, 0);
	SC_PREVWINDOW : Screen.ActiveForm.Perform( CM_DIALOGKEY, VK_TAB, 0);
	else inherited;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TWorkspaceTemplate.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	{* place holder *}
end;

end.
