unit Chooser_Address;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, Grids, DBGrids, IBUpdateSQL,
  Base_Chooser, Misc_Constants, Misc_Utilities;

function ChooseAddress( _tran : TIBTransaction; datAvailableAt : TDate; var keyInstance : Integer) : Boolean; overload;
function ChooseAddress( _tran : TIBTransaction; var keyInstance : Integer) : Boolean; overload;

type
  TAddressChooser = class(TChooserTemplate)
    AddressOnAnyDay: TIBQuery;

    AddressOnTheDay: TIBQuery;

    DataSourceOf_Address: TDataSource;

    Zip: TIBQuery;

    pagesHolder: TPageControl;

    pageCondition: TTabSheet;
    lblCategory: TLabel;
    cboCategory: TComboBox;
    txtNameRead: TLabeledEdit;
    txtName: TLabeledEdit;
    txtZipCode: TLabeledEdit;
    txtAddressRead: TLabeledEdit;
    txtAddress: TLabeledEdit;
    txtPhoneNumber: TLabeledEdit;
    txtFaxNumber: TLabeledEdit;

    pageResult: TTabSheet;
    gridAddress: TDBGrid;
    btnSelect: TButton;
    btnAppend: TButton;

    procedure txtZipCode_Change(Sender: TObject);

    procedure pageResult_Show(Sender: TObject);
    procedure btnSelect_Click(Sender: TObject);
    procedure btnAppend_Click(Sender: TObject);
  private
    { Private 錾 }
    procedure Retrieve( var keyInstance : Integer);
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  AddressChooser: TAddressChooser;

implementation

{$R *.dfm}

uses Set_Address;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function ChooseAddress( _tran : TIBTransaction; datAvailableAt : TDate; var keyInstance : Integer) : Boolean;
begin
	with TAddressChooser.Prepare do
	begin
		DataSourceOf_Address.DataSet := AddressOnTheDay;
		AddressOnTheDay.ParamByName( 'datAvailableAt').AsDate := datAvailableAt;

		if Select( _tran, result) then Retrieve( keyInstance);
		Release;
	end;
end;

function ChooseAddress( _tran : TIBTransaction; var keyInstance : Integer) : Boolean;
begin
	with TAddressChooser.Prepare do
	begin
		DataSourceOf_Address.DataSet := AddressOnAnyDay;
		btnAppend.Visible := false;

		if Select( _tran, result) then Retrieve( keyInstance);
		Release;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressChooser.Retrieve( var keyInstance : Integer);
begin
	with DataSourceOf_Address.DataSet do
        begin
		keyInstance := FieldByName( 'keyInstance').AsInteger;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressChooser.BeforePopup();
begin
	AddressOnTheDay.Transaction := Transaction;
	AddressOnAnyDay.Transaction := Transaction;
	Zip.Transaction := Transaction;
end;

procedure TAddressChooser.AfterPopup();
begin
	if DataSourceOf_Address.DataSet.IsEmpty then
		ErrorMessages.Add( 'ꏊIĂ܂B');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressChooser.txtZipCode_Change(Sender: TObject);
begin
	Zip.ParamByName( 'keyZIP').AsInteger := ToZipCode( txtZipCode.Text);
	Zip.Open;
	if not Zip.IsEmpty then
	begin
		txtAddressRead.Text := Trim( Zip.FieldByName( 'strAddressRead').AsString);
		txtAddress.Text := Trim( Zip.FieldByName( 'strAddress').AsString);
	end
	else
	begin
		txtAddressRead.Text := '';
		txtAddress.Text := '';
	end;
	Zip.Close;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressChooser.pageResult_Show(Sender: TObject);
begin
	with DataSourceOf_Address.DataSet as TIBQuery do
	begin
		Close;
		ParamByName( 'typCategory').AsInteger := cboCategory.ItemIndex;
		ParamByName( 'strNameRead').AsString := Trim( txtNameRead.Text);
		ParamByName( 'strName').AsString := Trim( txtName.Text);
		ParamByName( 'strAddressRead').AsString := Trim( txtAddressRead.Text);
		ParamByName( 'strAddress').AsString := Trim( txtAddress.Text);
		ParamByName( 'strPhoneNumber').AsString := ToDigits( txtPhoneNumber.Text);
		ParamByName( 'strFaxNumber').AsString := ToDigits( txtFaxNumber.Text);
		Open;
	end;

	btnSelect.Enabled := not DataSourceOf_Address.DataSet.IsEmpty;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressChooser.btnAppend_Click(Sender: TObject);
begin
	TAddressSet.Prepare.Append;
	pageResult_Show( Sender);
end;

procedure TAddressChooser.btnSelect_Click(Sender: TObject);
begin
	if DataSourceOf_Address.DataSet.IsEmpty then exit;
	TAddressSet.Prepare.Select( DataSourceOf_Address.DataSet.FieldByName( 'keyInstance').AsInteger);
end;

end.
