unit Chooser_Candidate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Chooser, Provider, ActnList, DBClient, DBLocal, DBLocalI,
  Grids, DBGrids, StdCtrls, DB, IBCustomDataSet, IBQuery, ExtCtrls,
  DBCtrls, Frame_ServerPrivateTable, Base_Frame, Frame_ServerPrivateGraph,
  ComCtrls, Piece_MinutesSelector, Piece_PatternSelector, Math,
  Piece_ValiditySelector, Buttons, IBDatabase, DateUtils,
  Misc_Constants, Misc_Utilities, IBEvents;

function ChooseCandidate(
	_tran : TIBTransaction;
	datAt : TDate;
	typPattern, optPattern : Integer;
	intMinutesFrom, intMinutesTo : Integer;
	var keyInstance : Integer
) : Boolean;

type
  TCandidateChooser = class(TChooserTemplate)
    Branch: TIBQuery;
    DataSourceOf_Branch: TDataSource;

    Region: TIBQuery;
    DataSourceOf_Region: TDataSource;
    DataSourceOf_Candidate: TDataSource;
    pagesChooser: TPageControl;

    pageCondition: TTabSheet;
    Pattern: TPatternSelector;
    lblBranch: TLabel;
    cboBranch: TDBLookupComboBox;
    lblRegion: TLabel;
    cboRegion: TDBLookupComboBox;
    txtCode: TLabeledEdit;
    txtFamilyNameRead: TLabeledEdit;
    txtFamilyName: TLabeledEdit;
    txtFirstName: TLabeledEdit;
    txtFirstNameRead: TLabeledEdit;
    radSex: TRadioGroup;
    txtAddress: TLabeledEdit;
    grpAvailability: TGroupBox;
    chkMonday: TCheckBox;
    chkTuesday: TCheckBox;
    chkWednesday: TCheckBox;
    chkSaturday: TCheckBox;
    chkFriday: TCheckBox;
    chkThursday: TCheckBox;
    chkSunday: TCheckBox;
    txtAvailability: TLabeledEdit;
    bvlCenter: TBevel;
    MinutesFrame: TShape;
    pnlMinutes: TPanel;
    lblMinutes: TLabel;
    MinutesFrom: TMinutesSelector;
    lblMinutesOver: TLabel;
    MinutesTo: TMinutesSelector;
    grpNotice: TGroupBox;
    txtTitle: TLabeledEdit;
    txtContent: TLabeledEdit;

    pageCandidates: TTabSheet;
    lblCounter: TLabel;
    btnLookupProfile: TButton;
    gridCandidates: TDBGrid;
    btnSelectProfile: TButton;

    pageScheduleGraph: TTabSheet;
    PrivateGraph: TServerPrivateGraphFrame;

    pageScheduleTable: TTabSheet;
    PrivateTable: TServerPrivateTableFrame;

    Shortcuts: TActionList;
    btnNextMonth: TSpeedButton;
    btnPrevMonth: TSpeedButton;
    pnlScheduleAt: TPanel;
    Candidate: TIBClientDataSet;
    EventListener: TIBEvents;

    procedure Schedule_Change(Sender: TObject);
    procedure btnPrevMonth_Click(Sender: TObject);
    procedure btnNextMonth_Click(Sender: TObject);

    procedure btnSelectProfile_Click(Sender: TObject);
    procedure btnLookupProfile_Click(Sender: TObject);

    procedure gridCandidates_TitleClick(Column: TColumn);

    procedure pagesChooser_Change(Sender: TObject);
    procedure pageCondition_Show(Sender: TObject);
    procedure pageCandidates_Show(Sender: TObject);
    procedure pageCandidates_Hide(Sender: TObject);
    procedure pageScheduleGraph_Show(Sender: TObject);
    procedure pageScheduleGraph_Hide(Sender: TObject);
    procedure pageScheduleTable_Show(Sender: TObject);
    procedure pageScheduleTable_Hide(Sender: TObject);

    procedure EventListener_EventAlert(Sender: TObject; EventName: String; EventCount: Integer; var CancelAlerts: Boolean);
  private
    { Private 錾 }
    FAvailableAt : TDate;
    FScheduleAt : TDate;
    FCandidate : Integer;
    FActivePage : TTabSheet;
    FConfigured : Boolean;
  protected
    { Protected 錾 }
    procedure Retrieve( var keyInstance : Integer);

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  CandidateChooser: TCandidateChooser;

implementation

{$R *.dfm}

uses MainDatastore, Chooser_Server, Set_Server;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function ChooseCandidate(
	_tran : TIBTransaction;
	datAt : TDate;
	typPattern, optPattern : Integer;
	intMinutesFrom, intMinutesTo : Integer;
	var keyInstance : Integer
) : Boolean;
begin
	with TCandidateChooser.Prepare do
	begin
		FAvailableAt := datAt;
		FScheduleAt := datAt;

		Branch.ParamByName( 'datAt').AsDate := datAt;
		Region.ParamByName( 'datAt').AsDate := datAt;

		Candidate.Params.ParamByName( 'datAt').AsDate := datAt;
		Candidate.Params.ParamByName( 'datRequiredFrom1').AsDate := datAt;
		Candidate.Params.ParamByName( 'datRequiredTo1').AsDate := DateOf( EndOfTheMonth( datAt));
		Candidate.Params.ParamByName( 'datRequiredFrom2').AsDate := StartOfTheMonth( IncMonth( datAt));
		Candidate.Params.ParamByName( 'datRequiredTo2').AsDate := DateOf( EndOfTheMonth( IncMonth( datAt)));

		Pattern.Reset( datAt, typPattern, optPattern);
		MinutesFrom.Value := intMinutesFrom;
		MinutesTo.Value := intMinutesTo;

		if Select( _tran, result) then Retrieve( keyInstance);
		Release;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidateChooser.Retrieve( var keyInstance : Integer);
begin
	keyInstance := Candidate.FieldByName( 'keyInstance').AsInteger;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidateChooser.BeforePopup();
begin
	Candidate.DBTransaction := Transaction;
	Branch.Transaction := Transaction;
	Region.Transaction := Transaction;
	// assign transaction

	Branch.Open;
	Branch.FetchAll;
	SelectComboWithoutFail( cboBranch, -1);

	Region.Open;
	Region.FetchAll;
	SelectComboWithoutFail( cboRegion, -1);

	Pattern.ReadOnly := false;
	MinutesFrom.ReadOnly := false;
	MinutesTo.ReadOnly := false;

	pagesChooser_Change( self);
	Schedule_Change( self);

	EventListener.RegisterEvents;
end;

procedure TCandidateChooser.AfterPopup();
begin
	if Candidate.IsEmpty then
		ErrorMessages.Add( '񋟎҂IĂ܂B');

	if ErrorMessages.Count = 0 then
		EventListener.UnregisterEvents;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidateChooser.Schedule_Change(Sender: TObject);
begin
	pnlScheduleAt.Caption := FormatDateTime( 'gg ee "N" yyyy" N "MM" ', FScheduleAt);
	btnPrevMonth.Enabled := FScheduleAt > FAvailableAt;

	PrivateGraph.Obsolete := true;
	PrivateTable.Obsolete := true;

	with FActivePage do if @OnHide <> nil then OnHide( self);
	with FActivePage do if @OnShow <> nil then OnShow( self);
end;

procedure TCandidateChooser.btnPrevMonth_Click(Sender: TObject);
begin
	FScheduleAt := IncMonth( FScheduleAt, -1);
	Schedule_Change( btnPrevMonth);
end;

procedure TCandidateChooser.btnNextMonth_Click(Sender: TObject);
begin
	FScheduleAt := IncMonth( FScheduleAt);
	Schedule_Change( btnNextMonth);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidateChooser.btnSelectProfile_Click(Sender: TObject);
begin
	if not Candidate.IsEmpty then TServerSet.Prepare.Select( ReadInstanceKey( Candidate));
end;

procedure TCandidateChooser.btnLookupProfile_Click(Sender: TObject);
var
	keyServer : Integer;
begin
	if not btnLookupProfile.Enabled then exit;
	if ChooseServer( Transaction, FAvailableAt, keyServer) then
	begin
		Candidate.Locate( 'keyInstance', keyServer, []);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidateChooser.gridCandidates_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Candidate.IndexFieldNames := 'strCode;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRNAMEREAD' then Candidate.IndexFieldNames := 'strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRBRANCH' then Candidate.IndexFieldNames := 'strBranch;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRREGION' then Candidate.IndexFieldNames := 'strRegion;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRADDRESS' then Candidate.IndexFieldNames := 'strAddressRead;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRPHONENUMBER1' then Candidate.IndexFieldNames := 'strPhoneNumber1;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRAVAILABILITY' then Candidate.IndexFieldNames := 'strAvailability;strNameRead;strName;keyInstance';

	with gridCandidates.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidateChooser.pagesChooser_Change(Sender: TObject);
begin
	FActivePage := pagesChooser.ActivePage;
end;

procedure TCandidateChooser.pageCondition_Show(Sender: TObject);
begin
	FConfigured := true;
end;

procedure TCandidateChooser.pageCandidates_Show(Sender: TObject);

	function IsSequential( datAt : TDate) : Boolean;
	begin
		case Pattern.TypeCode of
		PATTERN_DAY_OF_THE_EVERY_WEEK :
			result := ( ( ( 1 shl ( DayOfWeek( datAt) - 1)) and Pattern.MaskCode) <> 0);

		PATTERN_DAY_OF_THE_SECOND_WEEK :
			result := ( ( ( 1 shl ( DayOfWeek( datAt) - 1)) and Pattern.MaskCode) <> 0)
					and ( WeeksBetween( StartOfTheWeek( datAt), StartOfTheWeek( FAvailableAt)) mod 2 = 0);

		PATTERN_DAY_OF_THE_MONTH, PATTERN_COMPLEX, PATTERN_MULTIPLE :
			result := ( ( ( 1 shl ( DayOfTheMonth( datAt) - 1)) and (
					Pattern.MaskCode or ( BoolToInt( IntToBool( ( -1 shl ( DaysInMonth( datAt) - 1)) and Pattern.MaskCode)) shl ( DaysInMonth( datAt) - 1))
				)) <> 0);
		else
			result := true;
		end;
	end;

	function PatternMask( datFrom, datTo : TDate) : Integer;
	var
		datAt : TDate;
	begin
		result := 0;
		datAt := datFrom;
		while datAt <= datTo do
		begin
			result := result or ( BoolToInt( IsSequential( datAt)) shl ( DayOfTheMonth( datAt) - 1));
			datAt := IncDay( datAt);
		end;
	end;
begin
	with FActivePage do if @OnHide <> nil then OnHide( self);

	if FConfigured then with Candidate do
	begin
		Close;
		Params.ParamByName( 'keyBranch').AsInteger := VarToInt( cboBranch.KeyValue);
		Params.ParamByName( 'keyRegion').AsInteger := VarToInt( cboRegion.KeyValue);
		Params.ParamByName( 'strCode').AsString := Trim( txtCode.Text);
		Params.ParamByName( 'strFamilyNameRead').AsString := Trim( txtFamilyNameRead.Text);
		Params.ParamByName( 'strFamilyName').AsString := Trim( txtFamilyName.Text);
		Params.ParamByName( 'strFirstNameRead').AsString := Trim( txtFirstNameRead.Text);
		Params.ParamByName( 'strFirstName').AsString := Trim( txtFirstName.Text);
		Params.ParamByName( 'typSex').AsInteger := radSex.ItemIndex;
		Params.ParamByName( 'optAvailability').AsInteger := CheckBoxesToOptions( [
			chkSunday, chkMonday, chkTuesday, chkWednesday, chkThursday, chkFriday, chkSaturday
		]);
		Params.ParamByName( 'strAvailability').AsString := Trim( txtAvailability.Text);
		Params.ParamByName( 'useAddress').AsInteger := BoolToInt( Trim( txtAddress.Text) <> '');
		Params.ParamByName( 'strAddress').AsString := Trim( txtAddress.Text);
		Params.ParamByName( 'useNotice').AsInteger := BoolToInt( ( Trim( txtTitle.Text) + Trim( txtContent.Text)) <> '');
		Params.ParamByName( 'strTitle').AsString := Trim( txtTitle.Text);
		Params.ParamByName( 'strContent').AsString := Trim( txtContent.Text);

		Params.ParamByName( 'optAvailableAt1').AsInteger := PatternMask(
			Params.ParamByName( 'datRequiredFrom1').AsDate,
			Params.ParamByName( 'datRequiredTo1').AsDate
		);
		Params.ParamByName( 'optAvailableAt2').AsInteger := PatternMask(
			Params.ParamByName( 'datRequiredFrom2').AsDate,
			Params.ParamByName( 'datRequiredTo2').AsDate
		);
		Params.ParamByName( 'intMinutesFrom').AsInteger := MinutesFrom.Value;
		Params.ParamByName( 'intMinutesTo').AsInteger := MinutesTo.Value;
		Open;
		FConfigured := false;
	end;

	lblCounter.Caption := 'vF' + IntToStr( Candidate.RecordCount) + ' l';
	btnLookupProfile.Enabled := not Candidate.IsEmpty;
	btnSelectProfile.Enabled := btnLookupProfile.Enabled;
end;

procedure TCandidateChooser.pageCandidates_Hide(Sender: TObject);
begin
	FCandidate := ReadInstanceKey( Candidate);
	Shortcuts.State := asSuspended;
end;

procedure TCandidateChooser.pageScheduleGraph_Show(Sender: TObject);
begin
	if not Candidate.Active then pageCandidates_Show( Sender);

	with FActivePage do if @OnHide <> nil then OnHide( self);
	with PrivateGraph do if Obsolete or ( ServerKey <> FCandidate) then
		Reset( FCandidate, StartOfTheMonth( FScheduleAt), EndOfTheMonth( FScheduleAt));

	PrivateGraph.Enclose(
		Min( MinutesFrom.Value, MinutesTo.Value),
		Max( MinutesFrom.Value, MinutesTo.Value)
	);
	// Anchor //
	// Pattern Mask setting
	// optAvailability policy  Chooser_Profile
end;

procedure TCandidateChooser.pageScheduleGraph_Hide(Sender: TObject);
begin
	FCandidate := PrivateGraph.ServerKey;
	PrivateGraph.Shortcuts.State := asSuspended;
end;

procedure TCandidateChooser.pageScheduleTable_Show(Sender: TObject);
begin
	if not Candidate.Active then pageCandidates_Show( Sender);

	with FActivePage do if @OnHide <> nil then OnHide( self);
	with PrivateTable do if Obsolete or ( ServerKey <> FCandidate) then
		Reset( FCandidate, StartOfTheMonth( FScheduleAt), EndOfTheMonth( FScheduleAt));
end;

procedure TCandidateChooser.pageScheduleTable_Hide(Sender: TObject);
begin
	FCandidate := PrivateTable.ServerKey;
	PrivateTable.Shortcuts.State := asSuspended;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidateChooser.EventListener_EventAlert(Sender: TObject; EventName: String; EventCount: Integer; var CancelAlerts: Boolean);
begin
	FConfigured := true;
	Schedule_Change( self);
end;

end.
