unit Chooser_Client;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Chooser_Profile, DB, IBCustomDataSet, IBQuery, Grids, DBGrids,
  ExtCtrls, IBDatabase, DBCtrls, StdCtrls, ComCtrls, DateUtils, Misc_Constants;

function ChooseClient( _tran : TIBTransaction; var keyInstance : Integer) : Boolean; overload;
function ChooseClient( _tran : TIBTransaction; datAvailableAt : TDate; var keyInstance : Integer) : Boolean; overload;
function ChooseClients( _tran : TIBTransaction; datAvailableAt : TDate; var profiles : TProfileInfos) : Boolean;

type
  TClientChooser = class(TProfileChooser)
  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure BrowseProfile( keyInstance : Integer); override;
  public
    { Public 錾 }
  end;

var
  ClientChooser: TClientChooser;

implementation

{$R *.dfm}

uses Set_Client;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function ChooseClient( _tran : TIBTransaction; var keyInstance : Integer) : Boolean;
begin
	with TClientChooser.Prepare do
	begin
		DataSourceOf_Profile.DataSet := ProfileOnAnyDay;
		ProfileOnAnyDay.ParamByName( 'datAvailableAt').AsDate := Today;
		ProfileOnAnyDay.ParamByName( 'typCategory').AsInteger := CLIENT_PROFILE;

		if Select( _tran, result) then Retrieve( keyInstance);
		Release;
	end;
end;

function ChooseClient( _tran : TIBTransaction; datAvailableAt : TDate; var keyInstance : Integer) : Boolean;
begin
	with TClientChooser.Prepare do
	begin
		DataSourceOf_Profile.DataSet := ProfileOnTheDay;
		ProfileOnTheDay.ParamByName( 'datAvailableAt').AsDate := datAvailableAt;
		ProfileOnTheDay.ParamByName( 'typCategory').AsInteger := CLIENT_PROFILE;

		if Select( _tran, result) then Retrieve( keyInstance);
		Release;
	end;
end;

function ChooseClients( _tran : TIBTransaction; datAvailableAt : TDate; var profiles : TProfileInfos) : Boolean;
begin
	with TClientChooser.Prepare do
	begin
		DataSourceOf_Profile.DataSet := ProfileOnTheDay;
		ProfileOnTheDay.ParamByName( 'datAvailableAt').AsDate := datAvailableAt;
		ProfileOnTheDay.ParamByName( 'typCategory').AsInteger := CLIENT_PROFILE;

		if Select( _tran, result) then Retrieve( profiles);
		Release;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientChooser.BrowseProfile( keyInstance : Integer);
begin
	TClientSet.Prepare.Browse( keyInstance);
end;

end.
