unit Chooser_Profile;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, Grids, DBGrids, Base_Chooser, Math, DateUtils,
  Misc_Constants, Misc_Utilities;

type TProfileInfo = record
	key : Integer;
	code : String;
	familyName : String;
	familyNameRead : String;
	firstName : String;
	firstNameRead : String;
	birthday : TDate;
	sex : Integer;
	zip : Integer ;
	zipAddress : String;
	zipAddressRead : String;
	address : String;
	addressRead : String;
	phoneNumber1 : String;
	faxNumber1 : String;
    end;

    TProfileInfos = array of TProfileInfo;

type
  TProfileChooser = class(TChooserTemplate)
    Branch: TIBQuery;
    DataSourceOf_Branch: TDataSource;
    ProfileOnTheDay: TIBQuery;
    DataSourceOf_Profile: TDataSource;

    pagesHolder: TPageControl;
    pageCondition: TTabSheet;
    cboBranch: TDBLookupComboBox;
    txtCode: TLabeledEdit;
    txtFamilyNameRead: TLabeledEdit;
    txtFamilyName: TLabeledEdit;
    txtFirstNameRead: TLabeledEdit;
    txtFirstName: TLabeledEdit;
    txtAddress: TLabeledEdit;
    grpAvailability: TGroupBox;
    chkMonday: TCheckBox;
    chkTuesday: TCheckBox;
    chkWednesday: TCheckBox;
    chkSaturday: TCheckBox;
    chkFriday: TCheckBox;
    chkThursday: TCheckBox;
    chkSunday: TCheckBox;

    pageResult: TTabSheet;
    gridView: TDBGrid;
    btnBrowse: TButton;
    ProfileOnAnyDay: TIBQuery;
    Region: TIBQuery;
    DataSourceOf_Region: TDataSource;
    cboRegion: TDBLookupComboBox;
    lblBranch: TLabel;
    lblRegion: TLabel;
    txtAvailability: TLabeledEdit;
    grpNotice: TGroupBox;
    txtTitle: TLabeledEdit;
    txtContent: TLabeledEdit;
    radSex: TRadioGroup;

    procedure pageResult_Show(Sender: TObject);

    procedure btnBrowse_Click(Sender: TObject);
  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure Retrieve( var keyInstance : Integer); overload;
    procedure Retrieve( var profiles : TProfileInfos); overload;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;

    procedure BrowseProfile( keyInstance : Integer); virtual; abstract;
  public
    { Public 錾 }
  end;

var
  ProfileChooser: TProfileChooser;

implementation

{$R *.dfm}

uses MainDatastore;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileChooser.Retrieve( var keyInstance : Integer);
begin
	with DataSourceOf_Profile.DataSet as TIBQuery do
	begin
		keyInstance := FieldByName( 'keyInstance').AsInteger;
	end;
end;

procedure TProfileChooser.Retrieve( var profiles : TProfileInfos);
var
	Profile : TIBQuery;
	index : Integer;
begin
	Profile := DataSourceOf_Profile.DataSet as TIBQuery;
	Profile.DisableControls;
	Profile.FetchAll;
	Profile.First;

	SetLength( profiles, Profile.RecordCount);
	for index := 0 to Profile.RecordCount - 1 do
	begin
		with Profile, profiles[ index] do
		begin
			key := FieldByName( 'keyInstance').AsInteger;
			code := FieldByName( 'strCode').AsString;
			familyName := FieldByName( 'strFamilyName').AsString;
			familyNameRead := FieldByName( 'strFamilyNameRead').AsString;
			firstName := FieldByName( 'strFirstName').AsString;
			firstNameRead := FieldByName( 'strFirstNameRead').AsString;
			birthday := FieldByName( 'datBirthday').AsDateTime;
			sex := FieldByName( 'typSex').AsInteger;
			zip := FieldByName( 'refZip').AsInteger;
			zipAddress := FieldByName( 'strZipAddress').AsString;
			zipAddressRead := FieldByName( 'strZipAddressRead').AsString;
			address := FieldByName( 'strAddress').AsString;
			addressRead := FieldByName( 'strAddressRead').AsString;
			phoneNumber1 := FieldByName( 'strPhoneNumber1').AsString;
			faxNumber1 := FieldByName( 'strFaxNumber1').AsString;
			Next;
		end;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileChooser.BeforePopup();
begin
	ProfileOnAnyDay.Transaction := Transaction;
	ProfileOnTheDay.Transaction := Transaction;
	Branch.Transaction := Transaction;
	Region.Transaction := Transaction;
	// assign transaction

	if DataSourceOf_Profile.DataSet = ProfileOnAnyDay then
	begin
		Branch.ParamByName( 'datAt').Bound := True;
		Branch.ParamByName( 'datAt').Clear;
		Region.ParamByName( 'datAt').Bound := True;
		Region.ParamByName( 'datAt').Clear;
	end
	else
	begin
		Branch.ParamByName( 'datAt').AsDate := ProfileOnTheDay.ParamByName( 'datAvailableAt').AsDate;
		Region.ParamByName( 'datAt').AsDate := ProfileOnTheDay.ParamByName( 'datAvailableAt').AsDate;
	end;

	Branch.Open;
	Branch.FetchAll;
	SelectComboWithoutFail( cboBranch, -1);

	Region.Open;
	Region.FetchAll;
	SelectComboWithoutFail( cboRegion, -1);
end;

procedure TProfileChooser.AfterPopup();
begin
	if ( DataSourceOf_Profile.DataSet as TIBQuery).IsEmpty then
		ErrorMessages.Add( 'o^҂IĂ܂B');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileChooser.pageResult_Show(Sender: TObject);
begin
	with DataSourceOf_Profile.DataSet as TIBQuery do
	begin
		Close;
		ParamByName( 'keyBranch').AsInteger := VarToInt( cboBranch.KeyValue);
		ParamByName( 'keyRegion').AsInteger := VarToInt( cboRegion.KeyValue);
		ParamByName( 'strCode').AsString := Trim( txtCode.Text);
		ParamByName( 'strFamilyNameRead').AsString := Trim( txtFamilyNameRead.Text);
		ParamByName( 'strFamilyName').AsString := Trim( txtFamilyName.Text);
		ParamByName( 'strFirstNameRead').AsString := Trim( txtFirstNameRead.Text);
		ParamByName( 'strFirstName').AsString := Trim( txtFirstName.Text);
		ParamByName( 'typSex').AsInteger := radSex.ItemIndex;
		ParamByName( 'optAvailability').AsInteger := CheckBoxesToOptions( [
			chkSunday, chkMonday, chkTuesday, chkWednesday, chkThursday, chkFriday, chkSaturday
		]);
		ParamByName( 'strAvailability').AsString := Trim( txtAvailability.Text);
		ParamByName( 'useAddress').AsInteger := BoolToInt( Trim( txtAddress.Text) <> '');
		ParamByName( 'strAddress').AsString := Trim( txtAddress.Text);
		ParamByName( 'useNotice').AsInteger := BoolToInt( ( Trim( txtTitle.Text) + Trim( txtContent.Text)) <> '');
		ParamByName( 'strTitle').AsString := Trim( txtTitle.Text);
		ParamByName( 'strContent').AsString := Trim( txtContent.Text);
		Open;
	end;

	btnBrowse.Enabled := not DataSourceOf_Profile.DataSet.IsEmpty;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfileChooser.btnBrowse_Click(Sender: TObject);
begin
	if btnBrowse.Enabled then
		BrowseProfile( DataSourceOf_Profile.DataSet.FieldByName( 'keyInstance').AsInteger);
end;

end.
