unit Chooser_Server;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Chooser_Profile, DB, IBCustomDataSet, IBQuery, Grids, DBGrids,
  ExtCtrls, IBDatabase, DBCtrls, StdCtrls, ComCtrls, DateUtils, Misc_Constants;

function ChooseServer( _tran : TIBTransaction; var keyInstance : Integer) : Boolean; overload;
function ChooseServer( _tran : TIBTransaction; datAvailableAt : TDate; var keyInstance : Integer) : Boolean; overload;
function ChooseServers( _tran : TIBTransaction; datAvailableAt : TDate; var profiles : TProfileInfos) : Boolean;

type
  TServerChooser = class(TProfileChooser)
  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure BrowseProfile( keyInstance : Integer); override;
  public
    { Public 錾 }
  end;

var
  ServerChooser: TServerChooser;

implementation

{$R *.dfm}

uses Set_Server;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function ChooseServer( _tran : TIBTransaction; var keyInstance : Integer) : Boolean;
begin
	with TServerChooser.Prepare do
	begin
		DataSourceOf_Profile.DataSet := ProfileOnAnyDay;
		ProfileOnAnyDay.ParamByName( 'datAvailableAt').AsDate := Today;
		ProfileOnAnyDay.ParamByName( 'typCategory').AsInteger := SERVER_PROFILE;

		if Select( _tran, result) then Retrieve( keyInstance);
		Release;
	end;
end;

function ChooseServer( _tran : TIBTransaction; datAvailableAt : TDate; var keyInstance : Integer) : Boolean;
begin
	with TServerChooser.Prepare do
	begin
		DataSourceOf_Profile.DataSet := ProfileOnTheDay;
		ProfileOnTheDay.ParamByName( 'datAvailableAt').AsDate := datAvailableAt;
		ProfileOnTheDay.ParamByName( 'optAvailableAt').AsInteger := 1 shl ( DayOfTheMonth( datAvailableAt) - 1);
		ProfileOnTheDay.ParamByName( 'typCategory').AsInteger := SERVER_PROFILE;

		if Select( _tran, result) then Retrieve( keyInstance);
		Release;
	end;
end;

function ChooseServers( _tran : TIBTransaction; datAvailableAt : TDate; var profiles : TProfileInfos) : Boolean;
begin
	with TServerChooser.Prepare do
	begin
		DataSourceOf_Profile.DataSet := ProfileOnTheDay;
		ProfileOnTheDay.ParamByName( 'datAvailableAt').AsDate := datAvailableAt;
		ProfileOnTheDay.ParamByName( 'typCategory').AsInteger := SERVER_PROFILE;

		if Select( _tran, result) then Retrieve( profiles);
		Release;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerChooser.BrowseProfile( keyInstance : Integer);
begin
	TServerSet.Prepare.Browse( keyInstance);
end;

end.
