unit Chooser_Span;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, DateUtils, Base_Chooser, Misc_Constants, Misc_Utilities;

function ChooseSpan( var datFirstday, datLastday : TDate) : Boolean;

type
  TSpanChooser = class(TChooserTemplate)
    calFrom: TMonthCalendar;
    calTo: TMonthCalendar;
    lblOver: TLabel;
  private
    { Private 錾 }
    procedure Retrieve( var datFirstday, datLastday : TDate); overload;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  SpanChooser: TSpanChooser;

implementation

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function ChooseSpan( var datFirstday, datLastday : TDate) : Boolean;
begin
	with TSpanChooser.Prepare do
	begin
		calFrom.Date := DateOf( datFirstday);
		calTo.Date := DateOf( datLastday);

		if Select( nil, result) then Retrieve( datFirstday, datLastday);
		Release;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSpanChooser.Retrieve( var datFirstday, datLastday : TDate);
begin
	datFirstday := DateOf( calFrom.Date);
	datLastday := DateOf( calTo.Date);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSpanChooser.BeforePopup();
begin
end;

procedure TSpanChooser.AfterPopup();
begin
	if DateOf( calFrom.Date) >= DateOf( calTo.Date) then
		ErrorMessages.Add( 'ttA͓ɂȂĂ܂B');
end;

end.
