unit Dialog_Address;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, MainDatastore, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, IB, IBErrorCodes, DBClient, Provider,
  DBLocal, DBLocalI, IBSQL, IBDatabase, ComCtrls, DateUtils, IBUpdateSQL,
  Misc_Constants, Misc_Utilities, Base_Set, Piece_ValiditySelector,
  Base_Dialog;

type
  TAddressDialog = class(TDialogTemplate)

    Zip: TIBQuery;

    Validity: TValiditySelector;

    lblCategory: TLabel;
    cboCategory: TComboBox;
    txtNameRead: TLabeledEdit;
    txtName: TLabeledEdit;
    bvlName: TBevel;

    txtZipCode: TLabeledEdit;
    btnChooseZip: TButton;
    txtZipAddressRead: TLabeledEdit;
    txtZipAddress: TLabeledEdit;
    txtAddressRead: TEdit;
    txtAddress: TEdit;
    bvlLocation: TBevel;

    txtPhoneNumber1: TLabeledEdit;
    txtPhoneNumber2: TLabeledEdit;
    txtPhoneNumber3: TLabeledEdit;
    txtFaxNumber1: TLabeledEdit;
    txtFaxNumber2: TLabeledEdit;
    txtFaxNumber3: TLabeledEdit;
    btnPrint: TButton;
    btnPictureAlbum: TButton;
    btnLocator: TButton;

    procedure cboCategory_Click(Sender: TObject);

    procedure btnChooseZip_Click(Sender: TObject);
    procedure txtZipCode_Change(Sender: TObject);

    procedure btnLocator_Click(Sender: TObject);
    procedure btnPictureAlbum_Click(Sender: TObject);
    procedure btnPrint_Click(Sender: TObject);

  private
    { Private 錾 }
    FProfileKey : Integer;
    FLocatorX : Integer;
    FLocatorY : Integer;
  protected
    { Protected 錾 }
    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( keyProfile : Integer); overload;
  end;

var
  AddressDialog: TAddressDialog;

implementation

uses Chooser_Zip, Report_Address, Misc_Locator, Misc_PictureAlbum;

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TAddressDialog.Prepare( keyProfile : Integer);
begin
	inherited Create( Screen.ActiveForm);

	FProfileKey := keyProfile;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressDialog.BeforeInput();
begin
end;

procedure TAddressDialog.AfterInput();
begin
	with RecordSet do
	begin
		if Appending then Append else Edit;
		if Appending then FieldByName( 'keyInstance').AsInteger := TemporaryKey;
		FieldByName( 'codRevision').AsInteger := FieldByName( 'codRevision').AsInteger;
		FieldByName( 'typStatus').AsInteger := DATA_ENABLED;
		FieldByName( 'refProfile').AsInteger := FProfileKey;
		FieldByName( 'typCategory').AsInteger := cboCategory.ItemIndex;
		FieldByName( 'datAvailableFrom').AsDateTime := Validity.AvailableFrom;
		FieldByName( 'datAvailableTo').AsDateTime := Validity.AvailableTo;
		FieldByName( 'strName').AsString := Trim( txtName.Text);
		FieldByName( 'strNameRead').AsString := Trim( txtNameRead.Text);
		FieldByName( 'refZip').AsInteger := ToZipCode( txtZipCode.Text);
		FieldByName( 'strZipAddress').AsString := Trim( txtZipAddress.Text);
		FieldByName( 'strZipAddressRead').AsString := Trim( txtZipAddressRead.Text);
		FieldByName( 'strAddress').AsString := Trim( txtAddress.Text);
		FieldByName( 'strAddressRead').AsString := Trim( txtAddressRead.Text);
		FieldByName( 'strPhoneNumber1').AsString := Trim( txtPhoneNumber1.Text);
		FieldByName( 'strPhoneNumber2').AsString := Trim( txtPhoneNumber2.Text);
		FieldByName( 'strPhoneNumber3').AsString := Trim( txtPhoneNumber3.Text);
		FieldByName( 'strFaxNumber1').AsString := Trim( txtFaxNumber1.Text);
		FieldByName( 'strFaxNumber2').AsString := Trim( txtFaxNumber2.Text);
		FieldByName( 'strFaxNumber3').AsString := Trim( txtFaxNumber3.Text);
		FieldByName( 'intLocatorX').AsInteger := FLocatorX;
		FieldByName( 'intLocatorY').AsInteger := FLocatorY;
		Post;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressDialog.BeforeSelect();
begin
	with RecordSet do
	begin
		Validity.AvailableFrom := FieldByName( 'datAvailableFrom').AsDateTime;
		Validity.AvailableTo := FieldByName( 'datAvailableTo').AsDateTime;
		cboCategory.ItemIndex := FieldByName( 'typCategory').AsInteger;
		txtNameRead.Text := Trim( FieldByName( 'strNameRead').AsString);
		txtName.Text := Trim( FieldByName( 'strName').AsString);
		txtZipCode.Text := ToZipText( FieldByName( 'refZip').AsInteger);
		txtAddress.Text := Trim( FieldByName( 'strAddress').AsString);
		txtAddressRead.Text := Trim( FieldByName( 'strAddressRead').AsString);
		txtPhoneNumber1.Text := Trim( FieldByName( 'strPhoneNumber1').AsString);
		txtPhoneNumber2.Text := Trim( FieldByName( 'strPhoneNumber2').AsString);
		txtPhoneNumber3.Text := Trim( FieldByName( 'strPhoneNumber3').AsString);
		txtFaxNumber1.Text := Trim( FieldByName( 'strFaxNumber1').AsString);
		txtFaxNumber2.Text := Trim( FieldByName( 'strFaxNumber2').AsString);
		txtFaxNumber3.Text := Trim( FieldByName( 'strFaxNumber3').AsString);
		FLocatorX := FieldByName( 'intLocatorX').AsInteger;
		FLocatorY := FieldByName( 'intLocatorY').AsInteger;
	end;
end;

procedure TAddressDialog.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressDialog.BeforeAppend();
begin
	Validity.AvailableFrom := StartOfTheMonth( Today);
	Validity.AvailableTo := StrToDate( '2087/12/31');
	txtAddress.Text := '(Z͂Ă)';
	txtAddressRead.Text := '(Ẑ݂Ȃ͂Ă)';
	FLocatorX := 320;
	FLocatorY := 256;
end;

procedure TAddressDialog.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressDialog.BeforePopup();
begin
	Validity.ReadOnly := Browsing;
	cboCategory.Enabled := Appending;
	txtNameRead.ReadOnly := Browsing;
	txtName.ReadOnly := Browsing;
	txtZipCode.ReadOnly := Browsing;
	btnChooseZip.Enabled := not Browsing;
	txtAddress.ReadOnly := Browsing;
	txtAddressRead.ReadOnly := Browsing;
	txtPhoneNumber1.ReadOnly := Browsing;
	txtPhoneNumber2.ReadOnly := Browsing;
	txtPhoneNumber3.ReadOnly := Browsing;
	txtFaxNumber1.ReadOnly := Browsing;
	txtFaxNumber2.ReadOnly := Browsing;
	txtFaxNumber3.ReadOnly := Browsing;

	btnLocator.Enabled := not Browsing;
	btnPictureAlbum.Visible := ( not Appending) and ( RecordSet.FieldByName( 'keyInstance').AsInteger > 0);
	btnPrint.Visible := btnPictureAlbum.Visible;

	cboCategory_Click( cboCategory);
end;

procedure TAddressDialog.AfterPopup();
begin
	if cboCategory.ItemIndex <> PROFILE_ADDRESS then
	begin
		ErrorCheck_Empty( 'O݂', txtNameRead.Text, ErrorMessages);
		ErrorCheck_Reading( 'O݂', txtNameRead.Text, ErrorMessages);
		ErrorCheck_Empty( 'O', txtName.Text, ErrorMessages);
	end;

	ErrorCheck_Empty( 'X֔ԍ', txtZipCode.Text, ErrorMessages);
	if txtZipAddress.Text = '*********' then ErrorMessages.Add( 'X֔ԍ܂B');
	ErrorCheck_Reading( 'Z݂', txtAddressRead.Text, ErrorMessages);
	ErrorCheck_Digits( 'dbԍP', txtPhoneNumber1.Text, ErrorMessages);
	ErrorCheck_Digits( 'dbԍQ', txtPhoneNumber2.Text, ErrorMessages);
	ErrorCheck_Digits( 'dbԍR', txtPhoneNumber3.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍP', txtFaxNumber1.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍQ', txtFaxNumber2.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍR', txtFaxNumber3.Text, ErrorMessages);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressDialog.cboCategory_Click(Sender: TObject);
begin
	if cboCategory.ItemIndex = PROFILE_ADDRESS then
	begin
		txtNameRead.Text := '****************';
		txtName.Text := '****************';
		txtNameRead.ReadOnly := true;
		txtName.ReadOnly := true;
	end
	else
	begin
		txtNameRead.Text := Trim( RecordSet.FieldByName( 'strNameRead').AsString);
		txtName.Text := Trim( RecordSet.FieldByName( 'strName').AsString);
		txtNameRead.ReadOnly := Browsing;
		txtName.ReadOnly := Browsing;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressDialog.btnChooseZip_Click(Sender: TObject);
var
	keyZip : Integer;
begin
	if ChooseZip( Transaction, keyZip) then
	begin
		txtZipCode.Text := ToZipText( keyZip);
		txtAddressRead.SetFocus;
	end;
end;

procedure TAddressDialog.txtZipCode_Change(Sender: TObject);
begin
	Zip.ParamByName( 'keyZIP').AsInteger := ToZipCode( txtZipCode.Text);
	Zip.Open;
	if not Zip.IsEmpty then
	begin
		txtZipAddressRead.Text := Trim( Zip.FieldByName( 'strAddressRead').AsString);
		txtZipAddress.Text := Trim( Zip.FieldByName( 'strAddress').AsString);
	end
	else
	begin
		txtZipAddressRead.Text := '*********';
		txtZipAddress.Text := '*********';
	end;
	Zip.Close;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressDialog.btnLocator_Click(Sender: TObject);
begin
	if Browsing then
		BrowseLocator( FLocatorX, FLocatorY)
	else
		SelectLocator( FLocatorX, FLocatorY);
end;

procedure TAddressDialog.btnPictureAlbum_Click(Sender: TObject);
begin
	PopupPictureAlbum( OWNER_ADDRESS, RecordSet.FieldByName( 'keyInstance').AsInteger);
end;

procedure TAddressDialog.btnPrint_Click(Sender: TObject);
begin
	TAddressReport.Prepare( RecordSet.FieldByName( 'keyInstance').AsInteger).Preview;
end;

end.
