unit Dialog_Exchange;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, DateUtils, Base_Dialog, DBClient, Provider,
  Misc_Constants, Misc_Utilities, Piece_ValiditySelector;

type
  TExchangeDialog = class(TDialogTemplate)
    Validity: TValiditySelector;

    txtName: TLabeledEdit;
    txtAmountPerHour: TLabeledEdit;
    txtAmountPerCount: TLabeledEdit;
    lblCategory: TLabel;
    cboCategory: TComboBox;
    bvlAmount: TBevel;

  private
    { Private 錾 }
    FServiceKey : Integer;
  protected
    { Protected 錾 }
    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( keyService : Integer); overload;
  end;

  TExchangeFactory = class of TExchangeDialog;

var
  ExchangeDialog: TExchangeDialog;

implementation

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TExchangeDialog.Prepare( keyService : Integer);
begin
	inherited Create( Screen.ActiveForm);

	FServiceKey := keyService;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TExchangeDialog.BeforeInput();
begin
end;

procedure TExchangeDialog.AfterInput();
begin
	with RecordSet do
	begin
		if Appending then Append else Edit;
		if Appending then FieldByName( 'keyInstance').AsInteger := TemporaryKey;
		FieldByName( 'codRevision').AsInteger := FieldByName( 'codRevision').AsInteger;
		FieldByName( 'typStatus').AsInteger := FieldByName( 'typStatus').AsInteger;
		FieldByName( 'refService').AsInteger := FServiceKey;

		FieldByName( 'datAvailableFrom').AsDateTime := Validity.AvailableFrom;
		FieldByName( 'datAvailableTo').AsDateTime := Validity.AvailableTo;

		FieldByName( 'strName').AsString := Trim( txtName.Text);

		FieldByName( 'typCategory').AsInteger := cboCategory.ItemIndex;

		FieldByName( 'curAmountPerCount').AsFloat := StrToCurr( txtAmountPerCount.Text);
		FieldByName( 'curAmountPerHour').AsFloat := StrToCurr( txtAmountPerHour.Text);
		Post;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TExchangeDialog.BeforeSelect();
begin
	with RecordSet do
	begin
		Validity.AvailableFrom := FieldByName( 'datAvailableFrom').AsDateTime;
		Validity.AvailableTo := FieldByName( 'datAvailableTo').AsDateTime;

		txtName.Text := FieldByName( 'strName').AsString;

		cboCategory.ItemIndex := FieldByName( 'typCategory').AsInteger;

		txtAmountPerCount.Text := FieldByName( 'curAmountPerCount').AsString;
		txtAmountPerHour.Text := FieldByName( 'curAmountPerHour').AsString;
	end;
end;

procedure TExchangeDialog.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TExchangeDialog.BeforeAppend();
begin
	Validity.AvailableFrom := StartOfTheMonth( Today);
	Validity.AvailableTo := StrToDate( '2087/12/31');

	txtName.Text := '(O͂Ă)';
end;

procedure TExchangeDialog.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TExchangeDialog.BeforePopup();
begin
	Validity.ReadOnly := Browsing;
	txtName.ReadOnly := Browsing;
	cboCategory.Enabled := Appending;
	txtAmountPerCount.ReadOnly := not Appending;
	txtAmountPerHour.ReadOnly := not Appending;
end;

procedure TExchangeDialog.AfterPopup();

	procedure ErrorCheck_Decimal( caption, text : String; ErrorMessages : TStrings);
	begin
		if StrToCurrDef( text, -1) < 0 then
		begin
			ErrorMessages.Add( caption + '͔pgOȏ̏łȂ΂Ȃ܂B');
		end;
	end;

	procedure ErrorCheck_Integer( caption, text : String; ErrorMessages : TStrings);
	begin
		if StrToIntDef( text, -1) < 0 then
		begin
			ErrorMessages.Add( caption + '͔pgOȏ̐łȂ΂Ȃ܂B');
		end;
	end;
begin
	ErrorCheck_Empty( 'O', txtName.Text, ErrorMessages);

	case cboCategory.ItemIndex of
	TICKET_EXCHANGE :
		begin
			ErrorCheck_Empty( 'Œ蕪', txtAmountPerCount.Text, ErrorMessages);
			ErrorCheck_Decimal( 'Œ蕪', txtAmountPerCount.Text, ErrorMessages);

			ErrorCheck_Empty( ']ʕ', txtAmountPerHour.Text, ErrorMessages);
			ErrorCheck_Decimal( ']ʕ', txtAmountPerHour.Text, ErrorMessages);
		end;

	MONEY_EXCHANGE :
		begin
			ErrorCheck_Empty( 'Œ蕪', txtAmountPerCount.Text, ErrorMessages);
			ErrorCheck_Integer( 'Œ蕪', txtAmountPerCount.Text, ErrorMessages);

			ErrorCheck_Empty( ']ʕ', txtAmountPerHour.Text, ErrorMessages);
			ErrorCheck_Integer( ']ʕ', txtAmountPerHour.Text, ErrorMessages);
		end;
	end;
end;

end.
