unit Dialog_Notice;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBQuery,
  IBDatabase, ComCtrls, DateUtils, Base_Dialog, DBClient, Provider,
  Misc_Constants, Misc_Utilities, Piece_ValiditySelector;

type
  TNoticeDialog = class(TDialogTemplate)
    Validity: TValiditySelector;

    txtTitle: TLabeledEdit;
    lblContent: TLabel;
    txtContent: TMemo;

  private
    { Private 錾 }
    FProfileKey : Integer;
  protected
    { Protected 錾 }
    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( keyProfile : Integer); overload;
  end;

var
  NoticeDialog: TNoticeDialog;

implementation

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TNoticeDialog.Prepare( keyProfile : Integer);
begin
	inherited Create( Screen.ActiveForm);

	FProfileKey := keyProfile;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNoticeDialog.BeforeInput();
begin
end;

procedure TNoticeDialog.AfterInput();
begin
	with RecordSet do
	begin
		if Appending then Append else Edit;
		if Appending then FieldByName( 'keyInstance').AsInteger := TemporaryKey;
		FieldByName( 'codRevision').AsInteger := FieldByName( 'codRevision').AsInteger;
		FieldByName( 'typStatus').AsInteger := FieldByName( 'typStatus').AsInteger;
		FieldByName( 'refProfile').AsInteger := FProfileKey;
		FieldByName( 'datAvailableFrom').AsDateTime := Validity.AvailableFrom;
		FieldByName( 'datAvailableTo').AsDateTime := Validity.AvailableTo;
		FieldByName( 'strTitle').AsString := Trim( txtTitle.Text);
		FieldByName( 'strContent').AsString := txtContent.Lines.Text;
		Post;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNoticeDialog.BeforeSelect();
begin
	with RecordSet do
	begin
		Validity.AvailableFrom := FieldByName( 'datAvailableFrom').AsDateTime;
		Validity.AvailableTo := FieldByName( 'datAvailableTo').AsDateTime;

		txtTitle.Text := FieldByName( 'strTitle').AsString;
		txtContent.Lines.Text := FieldByName( 'strContent').AsString;
	end;
end;

procedure TNoticeDialog.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNoticeDialog.BeforeAppend();
begin
	Validity.AvailableFrom := Today;
	Validity.AvailableTo := StrToDate( '2087/12/31');
end;

procedure TNoticeDialog.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNoticeDialog.BeforePopup();
begin
	Validity.ReadOnly := Browsing;
	txtTitle.ReadOnly := Browsing;
	txtContent.ReadOnly := Browsing;
end;

procedure TNoticeDialog.AfterPopup();
begin
	if Trim( txtTitle.Text) = '' then
		ErrorMessages.Add( '^Cg͂Ă܂B');

	if Trim( txtContent.Lines.Text) = '' then
		ErrorMessages.Add( '{͂Ă܂B');

	if txtContent.Lines.Count > 9 then
		Application.MessageBox( 'sXszĂ܂BXsڈȌ͈Ɍ܂B', 'l̓');
end;

end.
