unit Frame_ClientPrivateTable;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, MainDatastore, Provider, DBClient, DBLocal, DBLocalI, DB, DateUtils,
  IBCustomDataSet, IBQuery, StdCtrls, Grids, DBGrids, IBSQL, IBDatabase, Math,
  ActnList, Misc_Constants, Misc_Utilities, Base_Frame;

type
  TClientPrivateTableFrame = class(TFrameTemplate)
    Profile: TIBQuery;
    Schedule: TIBClientDataSet;
    DataSourceOf_Schedule: TDataSource;

    txtProfileInfo: TEdit;
    btnSelectProfile: TButton;
    btnChooseProfile: TButton;

    gridTable: TDBGrid;

    btnSelectSchedule: TButton;
    lblCounter: TLabel;
    radShowEnabled: TRadioButton;
    radShowDisabled: TRadioButton;
    btnToggleSchedule: TButton;

    Shortcuts: TActionList;
    Shortcut_SelectProfile: TAction;

    procedure btnSelectProfile_Click(Sender: TObject);
    procedure btnChooseProfile_Click(Sender: TObject);

    procedure gridTable_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure gridTable_DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure gridTable_TitleClick(Column: TColumn);

    procedure radEnabler_Click(Sender: TObject);

    procedure btnSelectSchedule_Click(Sender: TObject);
    procedure btnToggleSchedule_Click(Sender: TObject);
  private
    { Private 錾 }
    FClientKey : Integer;
    FScheduleFrom : TDate;
    FScheduleTo : TDate;
    FObsolete : Boolean;

    sc_typSchedule, sc_datSchedule, sc_intMinutesAt, sc_intMinutesFor : Integer;
    sc_typExchange, sc_curAmountPerCount, sc_curAmountPerHour : Integer;
    sc_typAddressFrom, sc_refAddressFrom, sc_refResidentFrom, sc_strAddressFrom : Integer;
    sc_typAddressTo, sc_refAddressTo, sc_refResidentTo, sc_strAddressTo : Integer;
    sc_refClient : Integer;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property ClientKey : Integer read FClientKey;
    property ScheduleFrom : TDate read FScheduleFrom;
    property ScheduleTo : TDate read FScheduleTo;
    property Obsolete : Boolean read FObsolete write FObsolete;

    function ScheduleAt() : TDate;

    procedure Reset( keyProfile : Integer; datFrom, datTo : TDate);

    procedure SaveStyleToFile( FileName : String);
    procedure LoadStyleFromFile( FileName : String);
  end;

var
  ClientPrivateTableFrame: TClientPrivateTableFrame;

implementation

{$R *.dfm}

uses Chooser_Client, Set_Client, Set_Care, Set_Menage, Set_Migration, Set_Transfer;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TClientPrivateTableFrame.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	FClientKey := -1;
	FScheduleFrom := Today;
	FScheduleTo := Today;
	FObsolete := false;

	sc_typSchedule := -1; // procedure Reset( keyProfile : Integer; datFrom, datTo : TDate);

	SortByDefault( gridTable);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TClientPrivateTableFrame.ScheduleAt() : TDate;
begin
	if Schedule.IsEmpty then
		result := ScheduleFrom
	else
		result := Schedule.Fields[ sc_datSchedule].AsDateTime;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientPrivateTableFrame.Reset( keyProfile : Integer; datFrom, datTo : TDate);
var
	Position : TDataSetPosition;
begin
	FClientKey := keyProfile;
	FScheduleFrom := datFrom;
	FScheduleTo := datTo;
	// property update

	Profile.Close;
	Profile.ParamByName( 'keyInstance').AsInteger := ClientKey;
	Profile.ParamByName( 'datAvailableAt').AsDateTime := ScheduleTo;
	Profile.Open;

	if not Profile.IsEmpty then with Profile do
		txtProfileInfo.Text := Format( '%s / %s / %s / %s / %s/ %s', [
			Trim( FieldByName( 'strBranch').AsString),
			Trim( FieldByName( 'strRegion').AsString),
			Trim( FieldByName( 'strCode').AsString),
			Trim( FieldByName( 'strName').AsString),
			Trim( FieldByName( 'strNameRead').AsString),
			Trim( FieldByName( 'strPhoneNumber1').AsString),
			Trim( FieldByName( 'strAddress').AsString)
		])
	else
		txtProfileInfo.Text := 'o^敪 / Zn / o^ԍ / o^@ / ݁@ / dbԍP/ Z';
	// Profile update

	DisableGridSet( gridTable, Position);
	Schedule.Close;
	Schedule.Params.ParamByName( 'keyRecipient').AsInteger := ClientKey;
	Schedule.Params.ParamByName( 'datFrom').AsDate := ScheduleFrom;
	Schedule.Params.ParamByName( 'datTo').AsDate := ScheduleTo;
	Schedule.Open;
	radEnabler_Click( radShowEnabled);

	if sc_typSchedule < 0 then
	begin
		sc_typSchedule := Schedule.FieldByName( 'typSchedule').Index;
		sc_datSchedule := Schedule.FieldByName( 'datSchedule').Index;
		sc_intMinutesAt := Schedule.FieldByName( 'intMinutesAt').Index;
		sc_intMinutesFor := Schedule.FieldByName( 'intMinutesFor').Index;
		sc_typExchange := Schedule.FieldByName( 'typExchange').Index;
		sc_curAmountPerCount := Schedule.FieldByName( 'curAmountPerCount').Index;
		sc_curAmountPerHour := Schedule.FieldByName( 'curAmountPerHour').Index;
		sc_typAddressFrom := Schedule.FieldByName( 'typAddressFrom').Index;
		sc_refAddressFrom := Schedule.FieldByName( 'refAddressFrom').Index;
		sc_refResidentFrom := Schedule.FieldByName( 'refResidentFrom').Index;
		sc_strAddressFrom := Schedule.FieldByName( 'strAddressFrom').Index;
		sc_typAddressTo := Schedule.FieldByName( 'typAddressTo').Index;
		sc_refAddressTo := Schedule.FieldByName( 'refAddressTo').Index;
		sc_refResidentTo := Schedule.FieldByName( 'refResidentTo').Index;
		sc_strAddressTo := Schedule.FieldByName( 'strAddressTo').Index;
		sc_refClient := Schedule.FieldByName( 'refClient').Index;
	end;

	EnableGridSet( gridTable, Position);
	// Schedule update

	Obsolete := false;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientPrivateTableFrame.SaveStyleToFile( FileName : String);
begin
	gridTable.Columns.SaveToFile( FileName);
end;

procedure TClientPrivateTableFrame.LoadStyleFromFile( FileName : String);
begin
	gridTable.Columns.LoadFromFile( FileName);
	SortByDefault( gridTable);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientPrivateTableFrame.btnSelectProfile_Click(Sender: TObject);
begin
	TClientSet.Prepare.Select( ClientKey);
end;

procedure TClientPrivateTableFrame.btnChooseProfile_Click(Sender: TObject);
var
	keyClient : Integer;
begin
	if ChooseClient( DataStore.MainTransaction, ScheduleTo, keyClient) then
	begin
		Reset( keyClient, ScheduleFrom, ScheduleTo);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientPrivateTableFrame.gridTable_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	strAddressFrom, strAddressTo, strExchange : String;
begin
	if Column.Field.IsNull then
	begin
		gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, '@');
		exit;
	end;

	with Column do if Field.Index = sc_datSchedule then
	begin
		gridTable.Canvas.TextRect( Rect, Rect.Left + 6, Rect.Top + 2,
			FormatDateTime( 'dd"" (ddd)', Column.Field.AsDateTime)
		);
		exit;
	end;

	with Column do if Field.Index = sc_intMinutesAt then
	begin
		with gridTable.Canvas do case Schedule.Fields[ sc_typSchedule].AsInteger of
		     CARE_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, RangeToText( Field.AsInteger, Schedule.Fields[ sc_intMinutesFor].AsInteger));
		   MENAGE_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, RangeToText( Field.AsInteger, Schedule.Fields[ sc_intMinutesFor].AsInteger));
		MIGRATION_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, MinutesToText( Field.AsInteger));
		 TRANSFER_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, MinutesToText( Field.AsInteger));
		end;
		exit;
	end;

	if Column.Field.Index = sc_strAddressTo then with Schedule, gridTable.Canvas do
	begin
		if ( Fields[ sc_typAddressFrom].AsInteger = PROFILE_ADDRESS)
		    and ( Fields[ sc_refResidentFrom].AsInteger = ClientKey) then
			strAddressFrom := 'p҂̎'
		else
			strAddressFrom := Fields[ sc_strAddressFrom].AsString;

		if ( Fields[ sc_typAddressTo].AsInteger = PROFILE_ADDRESS)
		    and ( Fields[ sc_refResidentTo].AsInteger = ClientKey) then
			strAddressTo := 'p҂̎'
		else
			strAddressTo := Fields[ sc_strAddressTo].AsString;

		case Schedule.Fields[ sc_typSchedule].AsInteger of CARE_SCHEDULE, MENAGE_SCHEDULE :
			TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '%s', [ strAddressFrom]));
		else
			if ( Fields[ sc_typAddressFrom].AsInteger = PROFILE_ADDRESS)
			    and ( Fields[ sc_refResidentFrom].AsInteger = Fields[ sc_refClient].AsInteger) then
				TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '@ %s', [ strAddressTo]))
			else if ( Fields[ sc_typAddressTo].AsInteger = PROFILE_ADDRESS)
			    and ( Fields[ sc_refResidentTo].AsInteger = Fields[ sc_refClient].AsInteger) then
				TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '%s', [ strAddressFrom]))
			else
				TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '@ %s%s', [ strAddressFrom, strAddressTo]));
		end;
		exit;
	end;

	with Column do if Field.Index = sc_typExchange then
	begin
		strExchange := AmountToText(
			Schedule.Fields[ sc_typExchange].AsInteger,
			Schedule.Fields[ sc_curAmountPerCount].AsCurrency,
			Schedule.Fields[ sc_curAmountPerHour].AsCurrency,
			Schedule.Fields[ sc_intMinutesFor].AsInteger
		);
		gridTable.Canvas.TextRect(
			Rect,
			Rect.Right - 2 - gridTable.Canvas.TextWidth( strExchange),
			Rect.Top + 2,
			strExchange
		);
		exit;
	end;

	with Column do if PickList.Count > 0 then
	begin
		gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, PickList[ Field.AsInteger]);
		exit;
	end;

	gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientPrivateTableFrame.gridTable_DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
	Accept := false;
end;

procedure TClientPrivateTableFrame.gridTable_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'DATSCHEDULE' then Schedule.IndexFieldNames := 'datSchedule;intMinutesAt;intMinutesFor;strService;strAddressToRead';
	if Column.FieldName = 'STRSERVICE' then Schedule.IndexFieldNames := 'strService;datSchedule;intMinutesAt;intMinutesFor;strAddressToRead';
	if Column.FieldName = 'STRADDRESSTO' then Schedule.IndexFieldNames := 'strAddressToRead;datSchedule;intMinutesAt;intMinutesFor;strService';
	if Column.FieldName = 'STRSERVER' then Schedule.IndexFieldNames := 'strServerRead;datSchedule;intMinutesAt;intMinutesFor;strService;strAddressToRead';
	if Column.FieldName = 'STRNOTICE' then Schedule.IndexFieldNames := 'strNotice;datSchedule;intMinutesAt;intMinutesFor;strService;strAddressToRead';

	with gridTable.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientPrivateTableFrame.radEnabler_Click(Sender: TObject);
begin
	Schedule.Filter := Format( 'typStatus=%d', [ BoolToInt( radShowDisabled.Checked)]);

	lblCounter.Caption := 'vF' + IntToStr( Schedule.RecordCount) + ' ';

	if radShowEnabled.Checked then
		btnToggleSchedule.Caption := '폜'
	else
		btnToggleSchedule.Caption := '';

	btnSelectSchedule.Enabled := not Schedule.IsEmpty;
	btnToggleSchedule.Enabled := not Schedule.IsEmpty;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TClientPrivateTableFrame.btnSelectSchedule_Click(Sender: TObject);
begin
	if Schedule.IsEmpty then exit;
	if radShowEnabled.Checked then
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Select( Schedule.FieldByName( 'keyInstance').AsInteger);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Select( Schedule.FieldByName( 'keyInstance').AsInteger);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Select( Schedule.FieldByName( 'keyInstance').AsInteger);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Select( Schedule.FieldByName( 'keyInstance').AsInteger);
		end
	else
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Browse( Schedule.FieldByName( 'keyInstance').AsInteger);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Browse( Schedule.FieldByName( 'keyInstance').AsInteger);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Browse( Schedule.FieldByName( 'keyInstance').AsInteger);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Browse( Schedule.FieldByName( 'keyInstance').AsInteger);
		end;
end;

procedure TClientPrivateTableFrame.btnToggleSchedule_Click(Sender: TObject);
begin
	if Schedule.IsEmpty then exit;
	if radShowEnabled.Checked then
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Delete( Schedule.FieldByName( 'keyInstance').AsInteger);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Delete( Schedule.FieldByName( 'keyInstance').AsInteger);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Delete( Schedule.FieldByName( 'keyInstance').AsInteger);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Delete( Schedule.FieldByName( 'keyInstance').AsInteger);
		end
	else
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Restore( Schedule.FieldByName( 'keyInstance').AsInteger);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Restore( Schedule.FieldByName( 'keyInstance').AsInteger);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Restore( Schedule.FieldByName( 'keyInstance').AsInteger);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Restore( Schedule.FieldByName( 'keyInstance').AsInteger);
		end;
end;

end.
